/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.MultiMap;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpMethod;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.observability.HttpRequest;

public class HttpClientPush
implements HttpRequest {
    final int port;
    final String uri;
    final HttpMethod method;
    final String host;
    final HttpClientStream stream;
    final MultiMap headers;

    public HttpClientPush(Http2Headers headers, HttpClientStream stream) {
        int pos;
        String rawMethod = headers.method().toString();
        String authority = headers.authority() != null ? headers.authority().toString() : null;
        Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
        int n = pos = authority == null ? -1 : authority.indexOf(58);
        if (pos == -1) {
            this.host = authority;
            this.port = 80;
        } else {
            this.host = authority.substring(0, pos);
            this.port = Integer.parseInt(authority.substring(pos + 1));
        }
        this.method = HttpMethod.valueOf(rawMethod);
        this.uri = headers.path().toString();
        this.stream = stream;
        this.headers = headersMap;
    }

    @Override
    public int id() {
        return this.stream.id();
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String absoluteURI() {
        return null;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.stream.connection().remoteAddress();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }
}

