/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.opentelemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.List;

public interface OpenTelemetryAttributes {
    public static final AttributeKey<String> PULSAR_CLUSTER = AttributeKey.stringKey((String)"pulsar.cluster");
    public static final AttributeKey<String> PULSAR_NAMESPACE = AttributeKey.stringKey((String)"pulsar.namespace");
    public static final AttributeKey<String> PULSAR_TENANT = AttributeKey.stringKey((String)"pulsar.tenant");
    public static final AttributeKey<String> PULSAR_DOMAIN = AttributeKey.stringKey((String)"pulsar.domain");
    public static final AttributeKey<String> PULSAR_TOPIC = AttributeKey.stringKey((String)"pulsar.topic");
    public static final AttributeKey<Long> PULSAR_PARTITION_INDEX = AttributeKey.longKey((String)"pulsar.partition.index");
    public static final AttributeKey<String> PULSAR_SUBSCRIPTION_NAME = AttributeKey.stringKey((String)"pulsar.subscription.name");
    public static final AttributeKey<String> PULSAR_SUBSCRIPTION_TYPE = AttributeKey.stringKey((String)"pulsar.subscription.type");
    public static final AttributeKey<String> PULSAR_CONSUMER_NAME = AttributeKey.stringKey((String)"pulsar.consumer.name");
    public static final AttributeKey<Long> PULSAR_CONSUMER_ID = AttributeKey.longKey((String)"pulsar.consumer.id");
    public static final AttributeKey<List<String>> PULSAR_CONSUMER_METADATA = AttributeKey.stringArrayKey((String)"pulsar.consumer.metadata");
    public static final AttributeKey<Long> PULSAR_CONSUMER_CONNECTED_SINCE = AttributeKey.longKey((String)"pulsar.consumer.connected_since");
    public static final AttributeKey<String> PULSAR_CLIENT_ADDRESS = AttributeKey.stringKey((String)"pulsar.client.address");
    public static final AttributeKey<String> PULSAR_CLIENT_VERSION = AttributeKey.stringKey((String)"pulsar.client.version");
    public static final AttributeKey<String> PULSAR_TRANSACTION_STATUS = AttributeKey.stringKey((String)"pulsar.transaction.status");
    public static final AttributeKey<String> PULSAR_COMPACTION_STATUS = AttributeKey.stringKey((String)"pulsar.compaction.status");
    public static final AttributeKey<String> PULSAR_BACKLOG_QUOTA_TYPE = AttributeKey.stringKey((String)"pulsar.backlog.quota.type");

    public static enum BacklogQuotaType {
        SIZE,
        TIME;

        public final Attributes attributes = Attributes.of(PULSAR_BACKLOG_QUOTA_TYPE, (Object)this.name().toLowerCase());
    }

    public static enum CompactionStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(PULSAR_COMPACTION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum TransactionStatus {
        ACTIVE,
        COMMITTED,
        ABORTED;

        public final Attributes attributes = Attributes.of(PULSAR_TRANSACTION_STATUS, (Object)this.name().toLowerCase());
    }
}

