/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableExecuteNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.TableExecuteTarget target;
    private final Symbol rowCountSymbol;
    private final Symbol fragmentSymbol;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final Optional<PartitioningScheme> preferredPartitioningScheme;
    private final List<Symbol> outputs;

    @JsonCreator
    public TableExecuteNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.TableExecuteTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="fragmentSymbol") Symbol fragmentSymbol, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="preferredPartitioningScheme") Optional<PartitioningScheme> preferredPartitioningScheme) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.fragmentSymbol = Objects.requireNonNull(fragmentSymbol, "fragmentSymbol is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.preferredPartitioningScheme = Objects.requireNonNull(preferredPartitioningScheme, "preferredPartitioningScheme is null");
        Preconditions.checkArgument((partitioningScheme.isEmpty() || preferredPartitioningScheme.isEmpty() ? 1 : 0) != 0, (Object)"Both partitioningScheme and preferredPartitioningScheme cannot be present");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountSymbol).add((Object)fragmentSymbol);
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.TableExecuteTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public Symbol getFragmentSymbol() {
        return this.fragmentSymbol;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPreferredPartitioningScheme() {
        return this.preferredPartitioningScheme;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableExecute(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableExecuteNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.fragmentSymbol, this.columns, this.columnNames, this.partitioningScheme, this.preferredPartitioningScheme);
    }
}

