/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;

public class ExceptionRegionStartMarkerInstr
extends Instr {
    public final Label begin;
    public final Label end;
    public final Label firstRescueBlockLabel;
    public final Label ensureBlockLabel;

    public ExceptionRegionStartMarkerInstr(Label begin2, Label end2, Label ensureBlockLabel, Label firstRescueBlockLabel) {
        super(Operation.EXC_REGION_START);
        this.begin = begin2;
        this.end = end2;
        this.firstRescueBlockLabel = firstRescueBlockLabel;
        this.ensureBlockLabel = ensureBlockLabel;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append("(").append(this.begin).append(", ").append(this.end).append(", rescue[").append(this.firstRescueBlockLabel).append("]");
        if (this.ensureBlockLabel != null) {
            buf.append(", ensure[").append(this.ensureBlockLabel).append("]");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ExceptionRegionStartMarkerInstr(this);
    }
}

