/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.db;

import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.hadoop.mapred.lib.db.DBOutputFormat;
import org.apache.hadoop.mapred.lib.db.DBWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestConstructQuery {
    private String[] fieldNames = new String[]{"id", "name", "value"};
    private String[] nullFieldNames = new String[]{null, null, null};
    private String expected = "INSERT INTO hadoop_output (id,name,value) VALUES (?,?,?);";
    private String nullExpected = "INSERT INTO hadoop_output VALUES (?,?,?);";
    private DBOutputFormat<DBWritable, NullWritable> format = new DBOutputFormat();

    @Test
    public void testConstructQuery() {
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        Assert.assertEquals((Object)this.nullExpected, (Object)actual);
    }

    @Test
    public void testSetOutput() throws IOException {
        JobConf job = new JobConf();
        DBOutputFormat.setOutput((JobConf)job, (String)"hadoop_output", (String[])this.fieldNames);
        DBConfiguration dbConf = new DBConfiguration(job);
        String actual = this.format.constructQuery(dbConf.getOutputTableName(), dbConf.getOutputFieldNames());
        Assert.assertEquals((Object)this.expected, (Object)actual);
        job = new JobConf();
        dbConf = new DBConfiguration(job);
        DBOutputFormat.setOutput((JobConf)job, (String)"hadoop_output", (int)this.nullFieldNames.length);
        Assert.assertNull((Object)dbConf.getOutputFieldNames());
        Assert.assertEquals((long)this.nullFieldNames.length, (long)dbConf.getOutputFieldCount());
        actual = this.format.constructQuery(dbConf.getOutputTableName(), new String[dbConf.getOutputFieldCount()]);
        Assert.assertEquals((Object)this.nullExpected, (Object)actual);
    }
}

