/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class MultiTableInputFormat
extends MultiTableInputFormatBase
implements Configurable {
    public static final String SCANS = "hbase.mapreduce.scans";
    private Configuration conf = null;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        String[] rawScans = this.conf.getStrings(SCANS);
        if (rawScans.length <= 0) {
            throw new IllegalArgumentException("There must be at least 1 scan configuration set to : hbase.mapreduce.scans");
        }
        ArrayList<Scan> scans = new ArrayList<Scan>();
        for (int i = 0; i < rawScans.length; ++i) {
            try {
                scans.add(TableMapReduceUtil.convertStringToScan(rawScans[i]));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert Scan : " + rawScans[i] + " to string", e);
            }
        }
        this.setScans(scans);
    }
}

