/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;

@InterfaceAudience.Private
public class TezYarnClient
extends FrameworkClient {
    private final YarnClient yarnClient;
    private volatile boolean isRunning;

    protected TezYarnClient(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    @Override
    public void init(TezConfiguration tezConf) {
        this.yarnClient.init((Configuration)new YarnConfiguration((Configuration)tezConf));
    }

    @Override
    public void start() {
        this.yarnClient.start();
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.yarnClient.stop();
    }

    @Override
    public final void close() throws IOException {
        this.yarnClient.close();
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        return this.yarnClient.createApplication();
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appSubmissionContext) throws YarnException, IOException, TezException {
        ApplicationId appId = this.yarnClient.submitApplication(appSubmissionContext);
        ApplicationReport appReport = this.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            throw new TezException("Failed to submit application to YARN, applicationId=" + appId + ", diagnostics=" + appReport.getDiagnostics());
        }
        return appId;
    }

    @Override
    public void killApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ApplicationReport report = this.yarnClient.getApplicationReport(appId);
        if (report.getYarnApplicationState() == null) {
            throw new ApplicationNotFoundException("YARN reports no state for application " + appId);
        }
        return report;
    }

    @Override
    public boolean isRunning() throws IOException {
        return this.isRunning;
    }
}

