/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.metrics.impl.CounterImpl;
import org.apache.hadoop.hbase.metrics.impl.MetricRegistryImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricRegistryImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricRegistryImpl.class);
    private MetricRegistryInfo info;
    private MetricRegistryImpl registry;

    @Before
    public void setUp() {
        this.info = new MetricRegistryInfo("foo", "bar", "baz", "foobar", false);
        this.registry = new MetricRegistryImpl(this.info);
    }

    @Test
    public void testCounter() {
        Counter counter = this.registry.counter("mycounter");
        Assert.assertNotNull((Object)counter);
        counter.increment(42L);
        Optional metric = this.registry.get("mycounter");
        Assert.assertTrue((boolean)metric.isPresent());
        Assert.assertEquals((long)42L, (long)((Counter)metric.get()).getCount());
    }

    @Test
    public void testRegisterGauge() {
        this.registry.register("mygauge", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return 42L;
            }
        });
        Optional metric = this.registry.get("mygauge");
        Assert.assertTrue((boolean)metric.isPresent());
        Assert.assertEquals((long)42L, (long)((Long)((Gauge)metric.get()).getValue()));
    }

    @Test
    public void testRegisterGaugeLambda() {
        this.registry.register("gaugeLambda", () -> 42L);
        Optional metric = this.registry.get("gaugeLambda");
        Assert.assertTrue((boolean)metric.isPresent());
        Assert.assertEquals((long)42L, (long)((Long)((Gauge)metric.get()).getValue()));
    }

    @Test
    public void testTimer() {
        Timer timer = this.registry.timer("mytimer");
        Assert.assertNotNull((Object)timer);
        timer.updateNanos(100L);
    }

    @Test
    public void testMeter() {
        Meter meter = this.registry.meter("mymeter");
        Assert.assertNotNull((Object)meter);
        meter.mark();
    }

    @Test
    public void testRegister() {
        CounterImpl counter = new CounterImpl();
        this.registry.register("mycounter", (Metric)counter);
        counter.increment(42L);
        Optional metric = this.registry.get("mycounter");
        Assert.assertTrue((boolean)metric.isPresent());
        Assert.assertEquals((long)42L, (long)((Counter)metric.get()).getCount());
    }

    @Test
    public void testDoubleRegister() {
        Gauge g1 = this.registry.register("mygauge", () -> 42L);
        Gauge g2 = this.registry.register("mygauge", () -> 52L);
        Assert.assertEquals((Object)g1, (Object)g2);
        Optional metric = this.registry.get("mygauge");
        Assert.assertTrue((boolean)metric.isPresent());
        Assert.assertEquals((long)42L, (long)((Long)((Gauge)metric.get()).getValue()));
        Counter c1 = this.registry.counter("mycounter");
        Counter c2 = this.registry.counter("mycounter");
        Assert.assertEquals((Object)c1, (Object)c2);
    }

    @Test
    public void testGetMetrics() {
        CounterImpl counter = new CounterImpl();
        this.registry.register("mycounter", (Metric)counter);
        Gauge gauge = this.registry.register("mygauge", () -> 42L);
        Timer timer = this.registry.timer("mytimer");
        Map metrics = this.registry.getMetrics();
        Assert.assertEquals((long)3L, (long)metrics.size());
        Assert.assertEquals((Object)counter, metrics.get("mycounter"));
        Assert.assertEquals((Object)gauge, metrics.get("mygauge"));
        Assert.assertEquals((Object)timer, metrics.get("mytimer"));
    }
}

