/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.history.EventLogFileWriter;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.scheduler.EventLoggingListener$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerExecutorExcluded;
import org.apache.spark.scheduler.SparkListenerExecutorExcludedForStage;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorUnexcluded;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerNodeExcluded;
import org.apache.spark.scheduler.SparkListenerNodeExcludedForStage;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.scheduler.SparkListenerNodeUnexcluded;
import org.apache.spark.scheduler.SparkListenerResourceProfileAdded;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageExecutorMetrics;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd!B!C\u0001\u0011S\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\te\u0002\u0011\t\u0011)A\u0005g\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0012!Q\u00111\u0004\u0001C\u0002\u0013\u0005!)!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?A!\"!\r\u0001\u0005\u0004%\tAQA\u001a\u0011!\t)\u0005\u0001Q\u0001\n\u0005U\u0002\"CA$\u0001\t\u0007I\u0011BA%\u0011!\t\t\u0006\u0001Q\u0001\n\u0005-\u0003\"CA*\u0001\t\u0007I\u0011BA%\u0011!\t)\u0006\u0001Q\u0001\n\u0005-\u0003\"CA,\u0001\t\u0007I\u0011BA%\u0011!\tI\u0006\u0001Q\u0001\n\u0005-\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\ty\b\u0001Q\u0001\n\u0005}\u0003bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u0017\u0003A\u0011BAB\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fC\u0011\"a(\u0001#\u0003%I!!)\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\t9\u000f\u0001C!\u0003SDq!a=\u0001\t\u0003\n)\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0011\u001d\u0011Y\u0004\u0001C!\u0005{AqAa\u0012\u0001\t\u0003\u0012I\u0005C\u0004\u0003T\u0001!\tE!\u0016\t\u000f\t}\u0003\u0001\"\u0011\u0003b!9!1\u000e\u0001\u0005B\t5\u0004b\u0002B<\u0001\u0011\u0005#\u0011\u0010\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0011\u001d\u0011y\t\u0001C!\u0005#CqAa'\u0001\t\u0003\u0012i\nC\u0004\u0003(\u0002!\tE!+\t\u000f\tM\u0006\u0001\"\u0011\u00036\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bf\u0001\u0011\u0005#Q\u001a\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0011\u0019\u000f\u0001C!\u0005KDqAa<\u0001\t\u0003\u0012\t\u0010C\u0004\u0003|\u0002!\tE!@\t\u000f\r\u001d\u0001\u0001\"\u0011\u0004\n!911\u0003\u0001\u0005B\rU\u0001bBB\u0010\u0001\u0011\u00053\u0011\u0005\u0005\b\u0007K\u0001A\u0011AAB\u0011\u001d\u00199\u0003\u0001C\u0005\u0007S9\u0001ba\u000fC\u0011\u0003!5Q\b\u0004\b\u0003\nC\t\u0001RB \u0011\u001d\t\tA\u000fC\u0001\u0007\u000fB\u0011b!\u0013;\u0005\u0004%\taa\u0013\t\u0011\r]#\b)A\u0005\u0007\u001bB\u0011b!\u0017;\u0005\u0004%\taa\u0017\t\u0011\ru#\b)A\u0005\u0003KB\u0001ba\u0018;\t\u0003!5\u0011\r\u0002\u0015\u000bZ,g\u000e\u001e'pO\u001eLgn\u001a'jgR,g.\u001a:\u000b\u0005\r#\u0015!C:dQ\u0016$W\u000f\\3s\u0015\t)e)A\u0003ta\u0006\u00148N\u0003\u0002H\u0011\u00061\u0011\r]1dQ\u0016T\u0011!S\u0001\u0004_J<7c\u0001\u0001L\u001fB\u0011A*T\u0007\u0002\u0005&\u0011aJ\u0011\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\u0011\u0005A\u001bV\"A)\u000b\u0005I#\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005Q\u000b&a\u0002'pO\u001eLgnZ\u0001\u0006CB\u0004\u0018\nZ\u0002\u0001!\tA\u0016M\u0004\u0002Z?B\u0011!,X\u0007\u00027*\u0011ALV\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003Av\u000bA\"\u00199q\u0003R$X-\u001c9u\u0013\u0012\u00042AZ4X\u001b\u0005i\u0016B\u00015^\u0005\u0019y\u0005\u000f^5p]\u0006QAn\\4CCN,G)\u001b:\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017a\u00018fi*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005\r)&+S\u0001\ngB\f'o[\"p]\u001a\u0004\"\u0001^;\u000e\u0003\u0011K!A\u001e#\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005G>tgM\u0003\u0002~\r\u00061\u0001.\u00193p_BL!a >\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Qa\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010A\u0011A\n\u0001\u0005\u0006+\u001a\u0001\ra\u0016\u0005\u0006I\u001a\u0001\r!\u001a\u0005\u0006S\u001a\u0001\rA\u001b\u0005\u0006e\u001a\u0001\ra\u001d\u0005\u0006o\u001a\u0001\r\u0001\u001f\u000b\u000b\u0003\u000b\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001\"B+\b\u0001\u00049\u0006\"\u00023\b\u0001\u0004)\u0007\"B5\b\u0001\u0004Q\u0007\"\u0002:\b\u0001\u0004\u0019\u0018!\u00037pO^\u0013\u0018\u000e^3s+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u000f!L7\u000f^8ss*\u0019\u0011\u0011\u0006#\u0002\r\u0011,\u0007\u000f\\8z\u0013\u0011\ti#a\t\u0003%\u00153XM\u001c;M_\u001e4\u0015\u000e\\3Xe&$XM]\u0001\u000bY><wK]5uKJ\u0004\u0013\u0001\u00047pO\u001e,G-\u0012<f]R\u001cXCAA\u001b!\u0015\t9$!\u0011X\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u007fi\u0016AC2pY2,7\r^5p]&!\u00111IA\u001d\u0005-\t%O]1z\u0005V4g-\u001a:\u0002\u001b1|wmZ3e\u000bZ,g\u000e^:!\u0003U\u0019\bn\\;mI2{wM\u00117pG.,\u0006\u000fZ1uKN,\"!a\u0013\u0011\u0007\u0019\fi%C\u0002\u0002Pu\u0013qAQ8pY\u0016\fg.\u0001\ftQ>,H\u000e\u001a'pO\ncwnY6Va\u0012\fG/Z:!\u0003u\u0019\bn\\;mI2{wm\u0015;bO\u0016,\u00050Z2vi>\u0014X*\u001a;sS\u000e\u001c\u0018AH:i_VdG\rT8h'R\fw-Z#yK\u000e,Ho\u001c:NKR\u0014\u0018nY:!\u0003\u001d!Xm\u001d;j]\u001e\f\u0001\u0002^3ti&tw\rI\u0001\u0019Y&4Xm\u0015;bO\u0016,\u00050Z2vi>\u0014X*\u001a;sS\u000e\u001cXCAA0!!\t9$!\u0019\u0002f\u0005E\u0014\u0002BA2\u0003s\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0004g\u0003O\nY'a\u001b\n\u0007\u0005%TL\u0001\u0004UkBdWM\r\t\u0004M\u00065\u0014bAA8;\n\u0019\u0011J\u001c;\u0011\u000f\u0005]\u0012\u0011M,\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\u0011\u000b\u0001\"\u001a=fGV$xN]\u0005\u0005\u0003{\n9HA\bFq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t\u0003ea\u0017N^3Ti\u0006<W-\u0012=fGV$xN]'fiJL7m\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u0015\u0005c\u00014\u0002\b&\u0019\u0011\u0011R/\u0003\tUs\u0017\u000e^\u0001\rS:LG/\u0012<f]RdunZ\u0001\tY><WI^3oiR1\u0011QQAI\u00037Cq!a%\u0017\u0001\u0004\t)*A\u0003fm\u0016tG\u000fE\u0002M\u0003/K1!!'C\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\t\u0013\u0005ue\u0003%AA\u0002\u0005-\u0013a\u00034mkNDGj\\4hKJ\f!\u0003\\8h\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0015\u0016\u0005\u0003\u0017\n)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\t,X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Aygn\u0015;bO\u0016\u001cVOY7jiR,G\r\u0006\u0003\u0002\u0006\u0006m\u0006bBAJ1\u0001\u0007\u0011Q\u0018\t\u0004\u0019\u0006}\u0016bAAa\u0005\nY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f'V\u0014W.\u001b;uK\u0012\f1b\u001c8UCN\\7\u000b^1siR!\u0011QQAd\u0011\u001d\t\u0019*\u0007a\u0001\u0003\u0013\u00042\u0001TAf\u0013\r\tiM\u0011\u0002\u0017'B\f'o\u001b'jgR,g.\u001a:UCN\\7\u000b^1si\u0006\u0019rN\u001c+bg.<U\r\u001e;j]\u001e\u0014Vm];miR!\u0011QQAj\u0011\u001d\t\u0019J\u0007a\u0001\u0003+\u00042\u0001TAl\u0013\r\tIN\u0011\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:UCN\\w)\u001a;uS:<'+Z:vYR\f\u0011b\u001c8UCN\\WI\u001c3\u0015\t\u0005\u0015\u0015q\u001c\u0005\b\u0003'[\u0002\u0019AAq!\ra\u00151]\u0005\u0004\u0003K\u0014%\u0001F*qCJ\\G*[:uK:,'\u000fV1tW\u0016sG-A\np]\u0016sg/\u001b:p]6,g\u000e^+qI\u0006$X\r\u0006\u0003\u0002\u0006\u0006-\bbBAJ9\u0001\u0007\u0011Q\u001e\t\u0004\u0019\u0006=\u0018bAAy\u0005\nq2\u000b]1sW2K7\u000f^3oKJ,eN^5s_:lWM\u001c;Va\u0012\fG/Z\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$B!!\"\u0002x\"9\u00111S\u000fA\u0002\u0005e\bc\u0001'\u0002|&\u0019\u0011Q \"\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z\"p[BdW\r^3e\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0005\u0003\u000b\u0013\u0019\u0001C\u0004\u0002\u0014z\u0001\rA!\u0002\u0011\u00071\u00139!C\u0002\u0003\n\t\u0013Qc\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2Ti\u0006\u0014H/\u0001\u0005p]*{'-\u00128e)\u0011\t)Ia\u0004\t\u000f\u0005Mu\u00041\u0001\u0003\u0012A\u0019AJa\u0005\n\u0007\tU!IA\nTa\u0006\u00148\u000eT5ti\u0016tWM\u001d&pE\u0016sG-A\np]\ncwnY6NC:\fw-\u001a:BI\u0012,G\r\u0006\u0003\u0002\u0006\nm\u0001bBAJA\u0001\u0007!Q\u0004\t\u0004\u0019\n}\u0011b\u0001B\u0011\u0005\nq2\u000b]1sW2K7\u000f^3oKJ\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0003\u0012$W\rZ\u0001\u0016_:\u0014En\\2l\u001b\u0006t\u0017mZ3s%\u0016lwN^3e)\u0011\t)Ia\n\t\u000f\u0005M\u0015\u00051\u0001\u0003*A\u0019AJa\u000b\n\u0007\t5\"I\u0001\u0011Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\"m_\u000e\\W*\u00198bO\u0016\u0014(+Z7pm\u0016$\u0017AD8o+:\u0004XM]:jgR\u0014F\t\u0012\u000b\u0005\u0003\u000b\u0013\u0019\u0004C\u0004\u0002\u0014\n\u0002\rA!\u000e\u0011\u00071\u00139$C\u0002\u0003:\t\u0013\u0011d\u00159be.d\u0015n\u001d;f]\u0016\u0014XK\u001c9feNL7\u000f\u001e*E\t\u0006\u0011rN\\!qa2L7-\u0019;j_:\u001cF/\u0019:u)\u0011\t)Ia\u0010\t\u000f\u0005M5\u00051\u0001\u0003BA\u0019AJa\u0011\n\u0007\t\u0015#IA\u000fTa\u0006\u00148\u000eT5ti\u0016tWM]!qa2L7-\u0019;j_:\u001cF/\u0019:u\u0003Ayg.\u00119qY&\u001c\u0017\r^5p]\u0016sG\r\u0006\u0003\u0002\u0006\n-\u0003bBAJI\u0001\u0007!Q\n\t\u0004\u0019\n=\u0013b\u0001B)\u0005\nY2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012\fqb\u001c8Fq\u0016\u001cW\u000f^8s\u0003\u0012$W\r\u001a\u000b\u0005\u0003\u000b\u00139\u0006C\u0004\u0002\u0014\u0016\u0002\rA!\u0017\u0011\u00071\u0013Y&C\u0002\u0003^\t\u0013!d\u00159be.d\u0015n\u001d;f]\u0016\u0014X\t_3dkR|'/\u00113eK\u0012\f\u0011c\u001c8Fq\u0016\u001cW\u000f^8s%\u0016lwN^3e)\u0011\t)Ia\u0019\t\u000f\u0005Me\u00051\u0001\u0003fA\u0019AJa\u001a\n\u0007\t%$I\u0001\u000fTa\u0006\u00148\u000eT5ti\u0016tWM]#yK\u000e,Ho\u001c:SK6|g/\u001a3\u0002+=tW\t_3dkR|'O\u00117bG.d\u0017n\u001d;fIR!\u0011Q\u0011B8\u0011\u001d\t\u0019j\na\u0001\u0005c\u00022\u0001\u0014B:\u0013\r\u0011)H\u0011\u0002!'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s\u00052\f7m\u001b7jgR,G-\u0001\np]\u0016CXmY;u_J,\u0005p\u00197vI\u0016$G\u0003BAC\u0005wBq!a%)\u0001\u0004\u0011i\bE\u0002M\u0005\u007fJ1A!!C\u0005u\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016CXmY;u_J,\u0005p\u00197vI\u0016$\u0017!H8o\u000bb,7-\u001e;pe\nc\u0017mY6mSN$X\r\u001a$peN#\u0018mZ3\u0015\t\u0005\u0015%q\u0011\u0005\b\u0003'K\u0003\u0019\u0001BE!\ra%1R\u0005\u0004\u0005\u001b\u0013%\u0001K*qCJ\\G*[:uK:,'/\u0012=fGV$xN\u001d\"mC\u000e\\G.[:uK\u00124uN]*uC\u001e,\u0017AG8o\u000bb,7-\u001e;pe\u0016C8\r\\;eK\u00124uN]*uC\u001e,G\u0003BAC\u0005'Cq!a%+\u0001\u0004\u0011)\nE\u0002M\u0005/K1A!'C\u0005\u0015\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016CXmY;u_J,\u0005p\u00197vI\u0016$gi\u001c:Ti\u0006<W-A\rp]:{G-\u001a\"mC\u000e\\G.[:uK\u00124uN]*uC\u001e,G\u0003BAC\u0005?Cq!a%,\u0001\u0004\u0011\t\u000bE\u0002M\u0005GK1A!*C\u0005\u0011\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8fe:{G-\u001a\"mC\u000e\\G.[:uK\u00124uN]*uC\u001e,\u0017AF8o\u001d>$W-\u0012=dYV$W\r\u001a$peN#\u0018mZ3\u0015\t\u0005\u0015%1\u0016\u0005\b\u0003'c\u0003\u0019\u0001BW!\ra%qV\u0005\u0004\u0005c\u0013%!I*qCJ\\G*[:uK:,'OT8eK\u0016C8\r\\;eK\u00124uN]*uC\u001e,\u0017aF8o\u000bb,7-\u001e;peVs'\r\\1dW2L7\u000f^3e)\u0011\t)Ia.\t\u000f\u0005MU\u00061\u0001\u0003:B\u0019AJa/\n\u0007\tu&I\u0001\u0012Ta\u0006\u00148\u000eT5ti\u0016tWM]#yK\u000e,Ho\u001c:V]\nd\u0017mY6mSN$X\rZ\u0001\u0015_:,\u00050Z2vi>\u0014XK\\3yG2,H-\u001a3\u0015\t\u0005\u0015%1\u0019\u0005\b\u0003's\u0003\u0019\u0001Bc!\ra%qY\u0005\u0004\u0005\u0013\u0014%aH*qCJ\\G*[:uK:,'/\u0012=fGV$xN]+oKb\u001cG.\u001e3fI\u0006\trN\u001c(pI\u0016\u0014E.Y2lY&\u001cH/\u001a3\u0015\t\u0005\u0015%q\u001a\u0005\b\u0003'{\u0003\u0019\u0001Bi!\ra%1[\u0005\u0004\u0005+\u0014%\u0001H*qCJ\\G*[:uK:,'OT8eK\nc\u0017mY6mSN$X\rZ\u0001\u000f_:tu\u000eZ3Fq\u000edW\u000fZ3e)\u0011\t)Ia7\t\u000f\u0005M\u0005\u00071\u0001\u0003^B\u0019AJa8\n\u0007\t\u0005(IA\rTa\u0006\u00148\u000eT5ti\u0016tWM\u001d(pI\u0016,\u0005p\u00197vI\u0016$\u0017aE8o\u001d>$W-\u00168cY\u0006\u001c7\u000e\\5ti\u0016$G\u0003BAC\u0005ODq!a%2\u0001\u0004\u0011I\u000fE\u0002M\u0005WL1A!<C\u0005y\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe:{G-Z+oE2\f7m\u001b7jgR,G-\u0001\tp]:{G-Z+oKb\u001cG.\u001e3fIR!\u0011Q\u0011Bz\u0011\u001d\t\u0019J\ra\u0001\u0005k\u00042\u0001\u0014B|\u0013\r\u0011IP\u0011\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:O_\u0012,WK\\3yG2,H-\u001a3\u0002\u001d=t'\t\\8dWV\u0003H-\u0019;fIR!\u0011Q\u0011B\u0000\u0011\u001d\t\u0019j\ra\u0001\u0007\u0003\u00012\u0001TB\u0002\u0013\r\u0019)A\u0011\u0002\u001a'B\f'o\u001b'jgR,g.\u001a:CY>\u001c7.\u00169eCR,G-A\fp]\u0016CXmY;u_JlU\r\u001e:jGN,\u0006\u000fZ1uKR!\u0011QQB\u0006\u0011\u001d\t\u0019\n\u000ea\u0001\u0007\u001b\u00012\u0001TB\b\u0013\r\u0019\tB\u0011\u0002#'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t+B$\u0017\r^3\u0002-=t'+Z:pkJ\u001cW\r\u0015:pM&dW-\u00113eK\u0012$B!!\"\u0004\u0018!9\u00111S\u001bA\u0002\re\u0001c\u0001'\u0004\u001c%\u00191Q\u0004\"\u0003CM\u0003\u0018M]6MSN$XM\\3s%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u0006#G-\u001a3\u0002\u0019=tw\n\u001e5fe\u00163XM\u001c;\u0015\t\u0005\u001551\u0005\u0005\b\u0003'3\u0004\u0019AAK\u0003\u0011\u0019Ho\u001c9\u0002!I,G-Y2u!J|\u0007/\u001a:uS\u0016\u001cH\u0003BB\u0016\u0007o\u0001Ba!\f\u000445\u00111q\u0006\u0006\u0004\u0007cq\u0017\u0001B;uS2LAa!\u000e\u00040\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\re\u0002\b1\u0001\u0004,\u0005Q\u0001O]8qKJ$\u0018.Z:\u0002)\u00153XM\u001c;M_\u001e<\u0017N\\4MSN$XM\\3s!\ta%h\u0005\u0003;\u0007\u0003z\u0005c\u00014\u0004D%\u00191QI/\u0003\r\u0005s\u0017PU3g)\t\u0019i$A\bE\u000b\u001a\u000bU\u000b\u0014+`\u0019>;u\fR%S+\t\u0019i\u0005\u0005\u0003\u0004P\rUSBAB)\u0015\r\u0019\u0019F\\\u0001\u0005Y\u0006tw-C\u0002c\u0007#\n\u0001\u0003R#G\u0003VcEk\u0018'P\u000f~#\u0015J\u0015\u0011\u0002!\u0011\u0013\u0016JV#S?N#\u0016iR#`\u0017\u0016KVCAA3\u0003E!%+\u0013,F%~\u001bF+Q$F?.+\u0015\fI\u0001\fe\u0016$\u0017m\u0019;Fm\u0016tG\u000f\u0006\u0004\u0002n\u000e\r4Q\r\u0005\u0006e\u0002\u0003\ra\u001d\u0005\b\u0003'\u0003\u0005\u0019AAw\u0001")
public class EventLoggingListener
extends SparkListener
implements Logging {
    private final SparkConf sparkConf;
    private final EventLogFileWriter logWriter;
    private final ArrayBuffer<String> loggedEvents;
    private final boolean shouldLogBlockUpdates;
    private final boolean shouldLogStageExecutorMetrics;
    private final boolean testing;
    private final HashMap<Tuple2<Object, Object>, HashMap<String, ExecutorMetrics>> liveStageExecutorMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Object, Object> DRIVER_STAGE_KEY() {
        return EventLoggingListener$.MODULE$.DRIVER_STAGE_KEY();
    }

    public static String DEFAULT_LOG_DIR() {
        return EventLoggingListener$.MODULE$.DEFAULT_LOG_DIR();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public EventLogFileWriter logWriter() {
        return this.logWriter;
    }

    public ArrayBuffer<String> loggedEvents() {
        return this.loggedEvents;
    }

    private boolean shouldLogBlockUpdates() {
        return this.shouldLogBlockUpdates;
    }

    private boolean shouldLogStageExecutorMetrics() {
        return this.shouldLogStageExecutorMetrics;
    }

    private boolean testing() {
        return this.testing;
    }

    private HashMap<Tuple2<Object, Object>, HashMap<String, ExecutorMetrics>> liveStageExecutorMetrics() {
        return this.liveStageExecutorMetrics;
    }

    public void start() {
        this.logWriter().start();
        this.initEventLog();
    }

    private void initEventLog() {
        SparkListenerLogStart metadata = new SparkListenerLogStart(package$.MODULE$.SPARK_VERSION());
        String eventJson = JsonProtocol$.MODULE$.sparkEventToJsonString(metadata);
        this.logWriter().writeEvent(eventJson, true);
        if (this.testing() && this.loggedEvents() != null) {
            this.loggedEvents().$plus$eq((Object)eventJson);
            return;
        }
    }

    private void logEvent(SparkListenerEvent event, boolean flushLogger) {
        String eventJson = JsonProtocol$.MODULE$.sparkEventToJsonString(event);
        this.logWriter().writeEvent(eventJson, flushLogger);
        if (this.testing()) {
            this.loggedEvents().$plus$eq((Object)eventJson);
            return;
        }
    }

    private boolean logEvent$default$2() {
        return false;
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        Properties x$1 = this.redactProperties(event.properties());
        StageInfo x$2 = event.copy$default$1();
        this.logEvent(event.copy(x$2, x$1), this.logEvent$default$2());
        if (this.shouldLogStageExecutorMetrics()) {
            this.liveStageExecutorMetrics().put((Object)new Tuple2.mcII.sp(event.stageInfo().stageId(), event.stageInfo().attemptNumber()), (Object)HashMap$.MODULE$.empty());
            return;
        }
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd event) {
        this.logEvent(event, this.logEvent$default$2());
        if (this.shouldLogStageExecutorMetrics()) {
            Tuple2.mcII.sp stageKey = new Tuple2.mcII.sp(event.stageId(), event.stageAttemptId());
            this.liveStageExecutorMetrics().get((Object)stageKey).map((Function1 & Serializable & scala.Serializable)metricsPerExecutor -> BoxesRunTime.boxToBoolean((boolean)EventLoggingListener.$anonfun$onTaskEnd$1(event, metricsPerExecutor)));
            return;
        }
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate event) {
        this.logEvent(EventLoggingListener$.MODULE$.redactEvent(this.sparkConf, event), this.logEvent$default$2());
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted event) {
        if (this.shouldLogStageExecutorMetrics()) {
            int prevAttemptId = event.stageInfo().attemptNumber() - 1;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), prevAttemptId).foreach((Function1 & Serializable & scala.Serializable)attemptId -> EventLoggingListener.$anonfun$onStageCompleted$1(this, event, BoxesRunTime.unboxToInt((Object)attemptId)));
            Option executorOpt = this.liveStageExecutorMetrics().remove((Object)new Tuple2.mcII.sp(event.stageInfo().stageId(), event.stageInfo().attemptNumber()));
            executorOpt.foreach((Function1 & Serializable & scala.Serializable)execMap -> {
                execMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    EventLoggingListener.$anonfun$onStageCompleted$3($this, event$2, x0$1);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        this.logEvent(event, true);
    }

    @Override
    public void onJobStart(SparkListenerJobStart event) {
        Properties x$1 = this.redactProperties(event.properties());
        int x$2 = event.copy$default$1();
        long x$3 = event.copy$default$2();
        Seq<StageInfo> x$4 = event.copy$default$3();
        this.logEvent(event.copy(x$2, x$3, x$4, x$1), true);
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorBlacklisted(SparkListenerExecutorBlacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorExcluded(SparkListenerExecutorExcluded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorBlacklistedForStage(SparkListenerExecutorBlacklistedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorExcludedForStage(SparkListenerExecutorExcludedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeBlacklistedForStage(SparkListenerNodeBlacklistedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeExcludedForStage(SparkListenerNodeExcludedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorUnblacklisted(SparkListenerExecutorUnblacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorUnexcluded(SparkListenerExecutorUnexcluded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeBlacklisted(SparkListenerNodeBlacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeExcluded(SparkListenerNodeExcluded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeUnblacklisted(SparkListenerNodeUnblacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeUnexcluded(SparkListenerNodeUnexcluded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated event) {
        if (this.shouldLogBlockUpdates()) {
            this.logEvent(event, true);
            return;
        }
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
        if (this.shouldLogStageExecutorMetrics()) {
            String string = event.execId();
            String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.logEvent(event, this.logEvent$default$2());
            }
            event.executorUpdates().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                EventLoggingListener.$anonfun$onExecutorMetricsUpdate$1(this, event, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void onResourceProfileAdded(SparkListenerResourceProfileAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onOtherEvent(SparkListenerEvent event) {
        if (event.logEvent()) {
            this.logEvent(event, true);
            return;
        }
    }

    public void stop() {
        this.logWriter().stop();
    }

    private Properties redactProperties(Properties properties) {
        if (properties == null) {
            return properties;
        }
        Properties redactedProperties = new Properties();
        Tuple2 tuple2 = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()).toSeq().partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EventLoggingListener.$anonfun$redactProperties$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq globalProperties = (Seq)tuple2._1();
        Seq localProperties = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)globalProperties, (Object)localProperties);
        Seq globalProperties2 = (Seq)tuple22._1();
        Seq localProperties2 = (Seq)tuple22._2();
        ((IterableLike)Utils$.MODULE$.redact(this.sparkConf, (Seq<Tuple2<String, String>>)globalProperties2).$plus$plus((GenTraversableOnce)localProperties2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return redactedProperties.setProperty(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        return redactedProperties;
    }

    public static final /* synthetic */ boolean $anonfun$onTaskEnd$1(SparkListenerTaskEnd event$1, HashMap metricsPerExecutor) {
        ExecutorMetrics metrics = (ExecutorMetrics)metricsPerExecutor.getOrElseUpdate((Object)event$1.taskInfo().executorId(), (Function0 & Serializable & scala.Serializable)() -> new ExecutorMetrics());
        return metrics.compareAndUpdatePeakValues(event$1.taskExecutorMetrics());
    }

    public static final /* synthetic */ Option $anonfun$onStageCompleted$1(EventLoggingListener $this, SparkListenerStageCompleted event$2, int attemptId) {
        return $this.liveStageExecutorMetrics().remove((Object)new Tuple2.mcII.sp(event$2.stageInfo().stageId(), attemptId));
    }

    public static final /* synthetic */ void $anonfun$onStageCompleted$3(EventLoggingListener $this, SparkListenerStageCompleted event$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String executorId = (String)tuple2._1();
            ExecutorMetrics peakExecutorMetrics = (ExecutorMetrics)tuple2._2();
            $this.logEvent(new SparkListenerStageExecutorMetrics(executorId, event$2.stageInfo().stageId(), event$2.stageInfo().attemptNumber(), peakExecutorMetrics), $this.logEvent$default$2());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$onExecutorMetricsUpdate$1(EventLoggingListener $this, SparkListenerExecutorMetricsUpdate event$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 stageKey1 = (Tuple2)tuple2._1();
            ExecutorMetrics newPeaks = (ExecutorMetrics)tuple2._2();
            $this.liveStageExecutorMetrics().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                block2: {
                    block4: {
                        HashMap metricsPerExecutor;
                        block3: {
                            tuple2 = x0$2;
                            if (tuple2 == null) break block2;
                            Tuple2 stageKey2 = (Tuple2)tuple2._1();
                            metricsPerExecutor = (HashMap)tuple2._2();
                            Tuple2 tuple22 = stageKey1;
                            Tuple2<Object, Object> tuple23 = EventLoggingListener$.MODULE$.DRIVER_STAGE_KEY();
                            if (!(tuple22 == null ? tuple23 != null : !tuple22.equals(tuple23))) break block3;
                            Tuple2 tuple24 = stageKey1;
                            Tuple2 tuple25 = stageKey2;
                            if (tuple24 != null ? !tuple24.equals(tuple25) : tuple25 != null) break block4;
                        }
                        ExecutorMetrics metrics = (ExecutorMetrics)metricsPerExecutor.getOrElseUpdate((Object)event$3.execId(), (Function0 & Serializable & scala.Serializable)() -> new ExecutorMetrics());
                        return BoxesRunTime.boxToBoolean((boolean)metrics.compareAndUpdatePeakValues(newPeaks));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$redactProperties$1(EventLoggingListener $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return $this.sparkConf.contains(key);
        }
        throw new MatchError((Object)tuple2);
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        Logging.$init$(this);
        this.logWriter = EventLogFileWriter$.MODULE$.apply(appId, appAttemptId, logBaseDir, sparkConf, hadoopConf);
        this.loggedEvents = new ArrayBuffer();
        this.shouldLogBlockUpdates = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_BLOCK_UPDATES()));
        this.shouldLogStageExecutorMetrics = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_STAGE_EXECUTOR_METRICS()));
        this.testing = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_TESTING()));
        this.liveStageExecutorMetrics = HashMap$.MODULE$.empty();
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf) {
        this(appId, appAttemptId, logBaseDir, sparkConf, SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf));
    }
}

