/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProtobufMagic {
    public static final byte[] PB_MAGIC = new byte[]{80, 66, 85, 70};

    private ProtobufMagic() {
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        return ProtobufMagic.isPBMagicPrefix(bytes, 0, bytes.length);
    }

    private static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        if (bytes == null || len < PB_MAGIC.length) {
            return false;
        }
        return ProtobufMagic.compareTo(PB_MAGIC, 0, PB_MAGIC.length, bytes, offset, PB_MAGIC.length) == 0;
    }

    public static int lengthOfPBMagic() {
        return PB_MAGIC.length;
    }
}

