/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishImportTable;
import org.apache.accumulo.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.PopulateMetadataTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveExportedFiles
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(MoveExportedFiles.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MoveExportedFiles(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        try {
            Sets.SetView missingFiles;
            VolumeManager fs = master.getFileSystem();
            Map<String, String> fileNameMappings = PopulateMetadataTable.readMappingFile(fs, this.tableInfo);
            FileStatus[] exportedFiles = fs.listStatus(new Path(this.tableInfo.exportDir));
            FileStatus[] importedFiles = fs.listStatus(new Path(this.tableInfo.importDir));
            Function<FileStatus, String> fileStatusName = fstat -> fstat.getPath().getName();
            Set importing = Arrays.stream(exportedFiles).map(fileStatusName).map(fileNameMappings::get).collect(Collectors.toSet());
            Set imported = Arrays.stream(importedFiles).map(fileStatusName).collect(Collectors.toSet());
            if (log.isDebugEnabled()) {
                log.debug("Files already present in imported (target) directory: {}", (Object)imported.stream().collect(Collectors.joining(",")));
            }
            if (!(missingFiles = Sets.difference(new HashSet<String>(fileNameMappings.values()), new HashSet(Sets.union(importing, imported)))).isEmpty()) {
                throw new AcceptableThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Missing source files corresponding to files " + missingFiles.stream().collect(Collectors.joining(",")));
            }
            for (FileStatus fileStatus : exportedFiles) {
                String newName = fileNameMappings.get(fileStatus.getPath().getName());
                if (newName == null) continue;
                Path newPath = new Path(this.tableInfo.importDir, newName);
                log.debug("Renaming file {} to {}", (Object)fileStatus.getPath(), (Object)newPath);
                fs.rename(fileStatus.getPath(), newPath);
            }
            return new FinishImportTable(this.tableInfo);
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error renaming files " + ioe.getMessage());
        }
    }
}

