/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.PopulateMetadata;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;

class CreateDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    CreateDir(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        VolumeManager fs = master.getFileSystem();
        fs.mkdirs(new Path(this.tableInfo.dir));
        return new PopulateMetadata(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        VolumeManager fs = master.getFileSystem();
        fs.deleteRecursively(new Path(this.tableInfo.dir));
    }
}

