/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.metrics.ReplicationMetricsMBean;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMetrics
extends AbstractMetricsImpl
implements ReplicationMetricsMBean {
    private static final Logger log = LoggerFactory.getLogger(ReplicationMetrics.class);
    private static final String METRICS_PREFIX = "replication";
    private Master master;
    private ObjectName objectName = null;
    private ReplicationUtil replicationUtil;

    ReplicationMetrics(Master master) {
        this.master = master;
        try {
            this.objectName = new ObjectName("accumulo.server.metrics:service=Replication Metrics,name=ReplicationMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
        this.replicationUtil = new ReplicationUtil((AccumuloServerContext)master);
    }

    @Override
    public int getNumFilesPendingReplication() {
        if (TableState.ONLINE != Tables.getTableState((Instance)this.master.getInstance(), (String)"+rep")) {
            return 0;
        }
        Map peers = this.replicationUtil.getPeers();
        if (peers.isEmpty()) {
            return 0;
        }
        Set allConfiguredTargets = this.replicationUtil.getReplicationTargets();
        Map targetCounts = this.replicationUtil.getPendingReplications();
        int filesPending = 0;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (null == numFiles) continue;
            filesPending = (int)((long)filesPending + numFiles);
        }
        return filesPending;
    }

    @Override
    public int getNumConfiguredPeers() {
        return this.replicationUtil.getPeers().size();
    }

    @Override
    public int getMaxReplicationThreads() {
        return this.replicationUtil.getMaxReplicationThreads(this.master.getMasterMonitorInfo());
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }
}

