/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCoordinator {
    private static final Logger log = LoggerFactory.getLogger(EventCoordinator.class);
    long eventCounter = 0L;

    synchronized long waitForEvents(long millis, long lastEvent) {
        if (lastEvent == this.eventCounter) {
            if (millis <= 0L) {
                return this.eventCounter;
            }
            try {
                this.wait(millis);
            }
            catch (InterruptedException e) {
                log.debug("ignoring InterruptedException", (Throwable)e);
            }
        }
        return this.eventCounter;
    }

    public synchronized void event(String msg, Object ... args) {
        log.info(String.format(msg, args));
        ++this.eventCounter;
        this.notifyAll();
    }

    public Listener getListener() {
        return new Listener();
    }

    public class Listener {
        long lastEvent;

        Listener() {
            this.lastEvent = EventCoordinator.this.eventCounter;
        }

        public void waitForEvents(long millis) {
            this.lastEvent = EventCoordinator.this.waitForEvents(millis, this.lastEvent);
        }
    }
}

