/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.NativeCodeLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestScrLazyPersistFiles
extends LazyPersistTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() {
        DomainSocket.disableBindPathValidation();
    }

    @Before
    public void before() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        PlatformAssumptions.assumeNotWindows();
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();
        Preconditions.checkState((0x500000L >= osPageSize ? 1 : 0) != 0);
        Preconditions.checkState((0x500000L % osPageSize == 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRamDiskShortCircuitRead() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        int SEED = 1027565;
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeRandomTestFile(path, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        HdfsDataInputStream fis = (HdfsDataInputStream)this.fs.open(path);
        try {
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            Assert.assertEquals((long)4096L, (long)fis.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)4096L, (long)fis.getReadStatistics().getTotalShortCircuitBytesRead());
        }
        finally {
            fis.close();
            fis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesScrDuringEviction() throws Exception {
        this.getClusterBuilder().setUseScr(true).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        HdfsDataInputStream fis = (HdfsDataInputStream)this.fs.open(path1);
        try {
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            this.triggerEviction(this.cluster.getDataNodes().get(0));
            fis.read(0L, buf, 0, 4096);
            Assert.assertThat((Object)fis.getReadStatistics().getTotalBytesRead(), (Matcher)Is.is((Object)8192L));
            Assert.assertThat((Object)fis.getReadStatistics().getTotalShortCircuitBytesRead(), (Matcher)Is.is((Object)8192L));
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    @Test
    public void testScrAfterEviction() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadAfterEvictionTest();
    }

    @Test
    public void testLegacyScrAfterEviction() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadAfterEvictionTest();
        ClientContext clientContext = this.client.getClientContext();
        Assert.assertFalse((boolean)clientContext.getDisableLegacyBlockReaderLocal());
    }

    private void doShortCircuitReadAfterEvictionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        File metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        Assert.assertTrue((metaFile.length() <= (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        Assert.assertTrue((metaFile.length() > (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
    }

    @Test
    public void testScrBlockFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    @Test
    public void testLegacyScrBlockFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    public void doShortCircuitReadBlockFileCorruptionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.cluster.corruptReplica(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        this.exception.expect(ChecksumException.class);
        DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1);
    }

    @Test
    public void testScrMetaFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    @Test
    public void testLegacyScrMetaFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    public void doShortCircuitReadMetaFileCorruptionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.cluster.corruptMeta(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        this.exception.expect(ChecksumException.class);
        DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1);
    }
}

