/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.protobuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.Any;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.BytesValue;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProtobufUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProtobufUtil.class);
    private static final String TAG_STR = "tag-1";
    private static final byte TAG_TYPE = 10;

    @Test
    public void testException() throws IOException {
        HBaseProtos.NameBytesPair.Builder builder = HBaseProtos.NameBytesPair.newBuilder();
        String omg = "OMG!!!";
        builder.setName("java.io.IOException");
        builder.setValue(ByteString.copyFrom((byte[])Bytes.toBytes((String)"OMG!!!")));
        Throwable t = ProtobufUtil.toException((HBaseProtos.NameBytesPair)builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
        builder.clear();
        builder.setName("org.apache.hadoop.ipc.RemoteException");
        builder.setValue(ByteString.copyFrom((byte[])Bytes.toBytes((String)"OMG!!!")));
        t = ProtobufUtil.toException((HBaseProtos.NameBytesPair)builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
    }

    @Test
    public void testGet() throws IOException {
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        getBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        getBuilder.addColumn(columnBuilder.build());
        getBuilder.setLoadColumnFamiliesOnDemand(true);
        ClientProtos.Get proto = getBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        getBuilder = ClientProtos.Get.newBuilder((ClientProtos.Get)proto);
        getBuilder.setMaxVersions(1);
        getBuilder.setCacheBlocks(true);
        getBuilder.setTimeRange(ProtobufUtil.toTimeRange((TimeRange)TimeRange.allTime()));
        Get get = ProtobufUtil.toGet((ClientProtos.Get)proto);
        Assert.assertEquals((Object)getBuilder.build(), (Object)ProtobufUtil.toGet((Get)get));
    }

    @Test
    public void testDelete() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.DELETE);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION);
        qualifierBuilder.setTimestamp(111222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS);
        qualifierBuilder.setTimestamp(111333L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)proto);
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                qualifier.setValue(ByteString.EMPTY);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete));
    }

    @Test
    public void testPut() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.PUT);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        qualifierBuilder.setTimestamp(222222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)proto);
        long timestamp = put.getTimestamp();
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                if (qualifier.hasTimestamp()) continue;
                qualifier.setTimestamp(timestamp);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put));
    }

    @Test
    public void testScan() throws IOException {
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setStartRow(ByteString.copyFromUtf8((String)"row1"));
        scanBuilder.setStopRow(ByteString.copyFromUtf8((String)"row2"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        scanBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        scanBuilder.addColumn(columnBuilder.build());
        ClientProtos.Scan proto = scanBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        scanBuilder = ClientProtos.Scan.newBuilder((ClientProtos.Scan)proto);
        scanBuilder.setMaxVersions(2);
        scanBuilder.setCacheBlocks(false);
        scanBuilder.setCaching(1024);
        scanBuilder.setTimeRange(ProtobufUtil.toTimeRange((TimeRange)TimeRange.allTime()));
        scanBuilder.setIncludeStopRow(false);
        ClientProtos.Scan expectedProto = scanBuilder.build();
        ClientProtos.Scan actualProto = ProtobufUtil.toScan((Scan)ProtobufUtil.toScan((ClientProtos.Scan)expectedProto));
        Assert.assertEquals((Object)expectedProto, (Object)actualProto);
    }

    @Test
    public void testToCell() {
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), new byte[30]);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), new byte[30]);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), new byte[30]);
        byte[] arr = new byte[kv1.getLength() + kv2.getLength() + kv3.getLength()];
        System.arraycopy(kv1.getBuffer(), kv1.getOffset(), arr, 0, kv1.getLength());
        System.arraycopy(kv2.getBuffer(), kv2.getOffset(), arr, kv1.getLength(), kv2.getLength());
        System.arraycopy(kv3.getBuffer(), kv3.getOffset(), arr, kv1.getLength() + kv2.getLength(), kv3.getLength());
        ByteBuffer dbb = ByteBuffer.allocateDirect(arr.length);
        dbb.put(arr);
        ByteBufferKeyValue offheapKV = new ByteBufferKeyValue(dbb, kv1.getLength(), kv2.getLength());
        CellProtos.Cell cell = ProtobufUtil.toCell((Cell)offheapKV, (boolean)false);
        Cell newOffheapKV = ProtobufUtil.toCell((ExtendedCellBuilder)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY), (CellProtos.Cell)cell, (boolean)false);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)offheapKV, newOffheapKV) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIncrement() throws IOException {
        ClientProtos.MutationProto proto = this.getIncrementMutation(111111L);
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)proto, null);
        mutateBuilder.setTimestamp(increment.getTimestamp());
        mutateBuilder.setTimeRange(ProtobufUtil.toTimeRange((TimeRange)increment.getTimeRange()));
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.INCREMENT, (Mutation)increment));
    }

    private ClientProtos.MutationProto getIncrementMutation(Long timestamp) {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFrom((byte[])Bytes.toBytes((long)11L)));
        if (timestamp != null) {
            qualifierBuilder.setTimestamp(timestamp.longValue());
        }
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFrom((byte[])Bytes.toBytes((long)22L)));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        return mutateBuilder.build();
    }

    @Test
    public void testIncrementNoTimestamp() throws IOException {
        ClientProtos.MutationProto mutation = this.getIncrementMutation(null);
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, null);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)increment.getTimestamp());
        increment.getFamilyCellMap().values().forEach(cells -> cells.forEach(cell -> Assert.assertEquals((long)Long.MAX_VALUE, (long)cell.getTimestamp())));
    }

    @Test
    public void testAppend() throws IOException {
        ClientProtos.MutationProto proto = this.getAppendMutation(111111L);
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)proto, null);
        mutateBuilder.setTimestamp(append.getTimestamp());
        mutateBuilder.setTimeRange(ProtobufUtil.toTimeRange((TimeRange)append.getTimeRange()));
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.APPEND, (Mutation)append));
    }

    @Test
    public void testAppendNoTimestamp() throws IOException {
        ClientProtos.MutationProto mutation = this.getAppendMutation(null);
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)mutation, null);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)append.getTimestamp());
        append.getFamilyCellMap().values().forEach(cells -> cells.forEach(cell -> Assert.assertEquals((long)Long.MAX_VALUE, (long)cell.getTimestamp())));
    }

    private ClientProtos.MutationProto getAppendMutation(Long timestamp) {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.APPEND);
        if (timestamp != null) {
            mutateBuilder.setTimestamp(timestamp.longValue());
        }
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        if (timestamp != null) {
            qualifierBuilder.setTimestamp(timestamp.longValue());
        }
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        return mutateBuilder.build();
    }

    private static ProcedureProtos.Procedure.Builder createProcedureBuilder(long procId) {
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder();
        builder.setProcId(procId);
        builder.setClassName("java.lang.Object");
        builder.setSubmittedTime(0L);
        builder.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        builder.setLastUpdate(0L);
        return builder;
    }

    private static ProcedureProtos.Procedure createProcedure(long procId) {
        return TestProtobufUtil.createProcedureBuilder(procId).build();
    }

    private static LockServiceProtos.LockedResource createLockedResource(LockServiceProtos.LockedResourceType resourceType, String resourceName, LockServiceProtos.LockType lockType, ProcedureProtos.Procedure exclusiveLockOwnerProcedure, int sharedLockCount) {
        LockServiceProtos.LockedResource.Builder build = LockServiceProtos.LockedResource.newBuilder();
        build.setResourceType(resourceType);
        build.setResourceName(resourceName);
        build.setLockType(lockType);
        if (exclusiveLockOwnerProcedure != null) {
            build.setExclusiveLockOwnerProcedure(exclusiveLockOwnerProcedure);
        }
        build.setSharedLockCount(sharedLockCount);
        return build.build();
    }

    @Test
    public void testProcedureInfo() {
        ProcedureProtos.Procedure.Builder builder = TestProtobufUtil.createProcedureBuilder(1L);
        ByteString stateBytes = ByteString.copyFrom((byte[])new byte[]{65});
        BytesValue state = BytesValue.newBuilder().setValue(stateBytes).build();
        builder.addStateMessage(Any.pack((Message)state));
        ProcedureProtos.Procedure procedure = builder.build();
        String procJson = ProtobufUtil.toProcedureJson((List)Lists.newArrayList((Object[])new ProcedureProtos.Procedure[]{procedure}));
        Assert.assertEquals((Object)"[{\"className\":\"java.lang.Object\",\"procId\":\"1\",\"submittedTime\":\"0\",\"state\":\"RUNNABLE\",\"lastUpdate\":\"0\",\"stateMessage\":[{\"value\":\"QQ==\"}]}]", (Object)procJson);
    }

    @Test
    public void testServerLockInfo() {
        LockServiceProtos.LockedResource resource = TestProtobufUtil.createLockedResource(LockServiceProtos.LockedResourceType.SERVER, "server", LockServiceProtos.LockType.SHARED, null, 2);
        String lockJson = ProtobufUtil.toLockJson((List)Lists.newArrayList((Object[])new LockServiceProtos.LockedResource[]{resource}));
        Assert.assertEquals((Object)"[{\"resourceType\":\"SERVER\",\"resourceName\":\"server\",\"lockType\":\"SHARED\",\"sharedLockCount\":2}]", (Object)lockJson);
    }

    @Test
    public void testNamespaceLockInfo() {
        LockServiceProtos.LockedResource resource = TestProtobufUtil.createLockedResource(LockServiceProtos.LockedResourceType.NAMESPACE, "ns", LockServiceProtos.LockType.EXCLUSIVE, TestProtobufUtil.createProcedure(2L), 0);
        String lockJson = ProtobufUtil.toLockJson((List)Lists.newArrayList((Object[])new LockServiceProtos.LockedResource[]{resource}));
        Assert.assertEquals((Object)"[{\"resourceType\":\"NAMESPACE\",\"resourceName\":\"ns\",\"lockType\":\"EXCLUSIVE\",\"exclusiveLockOwnerProcedure\":{\"className\":\"java.lang.Object\",\"procId\":\"2\",\"submittedTime\":\"0\",\"state\":\"RUNNABLE\",\"lastUpdate\":\"0\"},\"sharedLockCount\":0}]", (Object)lockJson);
    }

    @Test
    public void testTableLockInfo() {
        LockServiceProtos.LockedResource resource = TestProtobufUtil.createLockedResource(LockServiceProtos.LockedResourceType.TABLE, "table", LockServiceProtos.LockType.SHARED, null, 2);
        String lockJson = ProtobufUtil.toLockJson((List)Lists.newArrayList((Object[])new LockServiceProtos.LockedResource[]{resource}));
        Assert.assertEquals((Object)"[{\"resourceType\":\"TABLE\",\"resourceName\":\"table\",\"lockType\":\"SHARED\",\"sharedLockCount\":2}]", (Object)lockJson);
    }

    @Test
    public void testRegionLockInfo() {
        LockServiceProtos.LockedResource resource = TestProtobufUtil.createLockedResource(LockServiceProtos.LockedResourceType.REGION, "region", LockServiceProtos.LockType.EXCLUSIVE, TestProtobufUtil.createProcedure(3L), 0);
        String lockJson = ProtobufUtil.toLockJson((List)Lists.newArrayList((Object[])new LockServiceProtos.LockedResource[]{resource}));
        Assert.assertEquals((Object)"[{\"resourceType\":\"REGION\",\"resourceName\":\"region\",\"lockType\":\"EXCLUSIVE\",\"exclusiveLockOwnerProcedure\":{\"className\":\"java.lang.Object\",\"procId\":\"3\",\"submittedTime\":\"0\",\"state\":\"RUNNABLE\",\"lastUpdate\":\"0\"},\"sharedLockCount\":0}]", (Object)lockJson);
    }

    @Test
    public void testCellConversionWithTags() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)true);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, true);
        List decodedTags = PrivateCellUtil.getTags((Cell)decodedCell);
        Assert.assertEquals((long)1L, (long)decodedTags.size());
        Tag decodedTag = (Tag)decodedTags.get(0);
        Assert.assertEquals((long)10L, (long)decodedTag.getType());
        Assert.assertEquals((Object)TAG_STR, (Object)Tag.getValueAsString((Tag)decodedTag));
    }

    private Cell getCellWithTags() {
        ArrayBackedTag tag = new ArrayBackedTag(10, TAG_STR);
        ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
        cellBuilder.setRow(Bytes.toBytes((String)"row1"));
        cellBuilder.setFamily(Bytes.toBytes((String)"f1"));
        cellBuilder.setQualifier(Bytes.toBytes((String)"q1"));
        cellBuilder.setValue(Bytes.toBytes((String)"value1"));
        cellBuilder.setType(Cell.Type.Delete);
        cellBuilder.setTags(Collections.singletonList(tag));
        return cellBuilder.build();
    }

    private Cell getCellFromProtoResult(CellProtos.Cell protoCell, boolean decodeTags) {
        ExtendedCellBuilder decodedBuilder = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
        return ProtobufUtil.toCell((ExtendedCellBuilder)decodedBuilder, (CellProtos.Cell)protoCell, (boolean)decodeTags);
    }

    @Test
    public void testCellConversionWithoutTags() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)false);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, false);
        List decodedTags = PrivateCellUtil.getTags((Cell)decodedCell);
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }

    @Test
    public void testTagEncodeFalseDecodeTrue() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)false);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, true);
        List decodedTags = PrivateCellUtil.getTags((Cell)decodedCell);
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }

    @Test
    public void testTagEncodeTrueDecodeFalse() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)true);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, false);
        List decodedTags = PrivateCellUtil.getTags((Cell)decodedCell);
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }
}

