/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestMutation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutation.class);

    @Test
    public void testAppendCopyConstructor() throws IOException {
        Append origin = new Append(Bytes.toBytes((String)"ROW-01"));
        origin.setPriority(100);
        byte[] family = Bytes.toBytes((String)"CF-01");
        origin.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(origin.getRow()).setFamily(family).setQualifier(Bytes.toBytes((String)"q")).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)100)).build());
        origin.addColumn(family, Bytes.toBytes((String)"q0"), Bytes.toBytes((String)"value"));
        origin.setTimeRange(100L, 1000L);
        Append clone = new Append(origin);
        this.assertEquals((Mutation)origin, (Mutation)clone);
        origin.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"value"));
        Assert.assertNotEquals((Object)origin.getCellList(family), (Object)clone.getCellList(family));
    }

    @Test
    public void testIncrementCopyConstructor() throws IOException {
        Increment origin = new Increment(Bytes.toBytes((String)"ROW-01"));
        origin.setPriority(100);
        byte[] family = Bytes.toBytes((String)"CF-01");
        origin.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(origin.getRow()).setFamily(family).setQualifier(Bytes.toBytes((String)"q")).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)100)).build());
        origin.addColumn(family, Bytes.toBytes((String)"q0"), 4L);
        origin.setTimeRange(100L, 1000L);
        Increment clone = new Increment(origin);
        this.assertEquals((Mutation)origin, (Mutation)clone);
        origin.addColumn(family, Bytes.toBytes((String)"q1"), 3L);
        Assert.assertNotEquals((Object)origin.getCellList(family), (Object)clone.getCellList(family));
    }

    @Test
    public void testDeleteCopyConstructor() throws IOException {
        Delete origin = new Delete(Bytes.toBytes((String)"ROW-01"));
        origin.setPriority(100);
        byte[] family = Bytes.toBytes((String)"CF-01");
        origin.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(origin.getRow()).setFamily(family).setQualifier(Bytes.toBytes((String)"q")).setType(Cell.Type.Delete).build());
        origin.addColumn(family, Bytes.toBytes((String)"q0"));
        origin.addColumns(family, Bytes.toBytes((String)"q1"));
        origin.addFamily(family);
        origin.addColumns(family, Bytes.toBytes((String)"q2"), 100L);
        origin.addFamilyVersion(family, 1000L);
        Delete clone = new Delete(origin);
        this.assertEquals((Mutation)origin, (Mutation)clone);
        origin.addColumn(family, Bytes.toBytes((String)"q3"));
        Assert.assertNotEquals((Object)origin.getCellList(family), (Object)clone.getCellList(family));
    }

    @Test
    public void testPutCopyConstructor() throws IOException {
        Put origin = new Put(Bytes.toBytes((String)"ROW-01"));
        origin.setPriority(100);
        byte[] family = Bytes.toBytes((String)"CF-01");
        origin.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(origin.getRow()).setFamily(family).setQualifier(Bytes.toBytes((String)"q")).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)"value")).build());
        origin.addColumn(family, Bytes.toBytes((String)"q0"), Bytes.toBytes((String)"V-01"));
        origin.addColumn(family, Bytes.toBytes((String)"q1"), 100L, Bytes.toBytes((String)"V-01"));
        Put clone = new Put(origin);
        this.assertEquals((Mutation)origin, (Mutation)clone);
        origin.addColumn(family, Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"V-02"));
        Assert.assertNotEquals((Object)origin.getCellList(family), (Object)clone.getCellList(family));
    }

    private void assertEquals(Mutation origin, Mutation clone) {
        Assert.assertEquals((long)origin.getFamilyCellMap().size(), (long)clone.getFamilyCellMap().size());
        for (byte[] family : origin.getFamilyCellMap().keySet()) {
            List originCells = origin.getCellList(family);
            List cloneCells = clone.getCellList(family);
            Assert.assertEquals((long)originCells.size(), (long)cloneCells.size());
            for (int i = 0; i != cloneCells.size(); ++i) {
                Cell originCell = (Cell)originCells.get(i);
                Cell cloneCell = (Cell)cloneCells.get(i);
                Assert.assertTrue((boolean)CellUtil.equals((Cell)originCell, (Cell)cloneCell));
                Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)originCell, (Cell)cloneCell));
            }
        }
        Assert.assertEquals((long)origin.getAttributesMap().size(), (long)clone.getAttributesMap().size());
        for (String name : origin.getAttributesMap().keySet()) {
            byte[] originValue = (byte[])origin.getAttributesMap().get(name);
            byte[] cloneValue = (byte[])clone.getAttributesMap().get(name);
            Assert.assertTrue((boolean)Bytes.equals((byte[])originValue, (byte[])cloneValue));
        }
        Assert.assertEquals((long)origin.getTimestamp(), (long)clone.getTimestamp());
        Assert.assertEquals((long)origin.getPriority(), (long)clone.getPriority());
        if (origin instanceof Append) {
            TestMutation.assertEquals(((Append)origin).getTimeRange(), ((Append)clone).getTimeRange());
        }
        if (origin instanceof Increment) {
            TestMutation.assertEquals(((Increment)origin).getTimeRange(), ((Increment)clone).getTimeRange());
        }
    }

    private static void assertEquals(TimeRange origin, TimeRange clone) {
        Assert.assertEquals((long)origin.getMin(), (long)clone.getMin());
        Assert.assertEquals((long)origin.getMax(), (long)clone.getMax());
    }

    @Test
    public void testRowIsImmutableOrNot() {
        Put putRowIsImmutable;
        byte[] rowKey = Bytes.toBytes((String)"immutable");
        Assert.assertTrue((rowKey == (putRowIsImmutable = new Put(rowKey, true)).getRow() ? 1 : 0) != 0);
        Put putRowIsNotImmutable = new Put(rowKey, 1000L, false);
        Assert.assertTrue((rowKey != putRowIsNotImmutable.getRow() ? 1 : 0) != 0);
    }

    @Test
    public void testAddImmutableToPut() throws IOException {
        byte[] row = Bytes.toBytes((String)"immutable-row");
        byte[] family = Bytes.toBytes((String)"immutable-family");
        byte[] qualifier0 = Bytes.toBytes((String)"immutable-qualifier-0");
        byte[] value0 = Bytes.toBytes((String)"immutable-value-0");
        byte[] qualifier1 = Bytes.toBytes((String)"immutable-qualifier-1");
        byte[] value1 = Bytes.toBytes((String)"immutable-value-1");
        long ts1 = 5000L;
        Put put = new Put(row, true);
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(family).setQualifier(qualifier0).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(value0).build()).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(family).setQualifier(qualifier1).setTimestamp(ts1).setType(Cell.Type.Put).setValue(value1).build());
        Cell cell0 = (Cell)put.get(family, qualifier0).get(0);
        Assert.assertTrue((cell0.getFamilyArray() == family ? 1 : 0) != 0);
        Assert.assertTrue((cell0.getQualifierArray() == qualifier0 ? 1 : 0) != 0);
        Assert.assertTrue((cell0.getValueArray() == value0 ? 1 : 0) != 0);
        Assert.assertTrue((cell0.getTimestamp() == put.getTimestamp() ? 1 : 0) != 0);
        Cell cell1 = (Cell)put.get(family, qualifier1).get(0);
        Assert.assertTrue((cell1.getFamilyArray() == family ? 1 : 0) != 0);
        Assert.assertTrue((cell1.getQualifierArray() == qualifier1 ? 1 : 0) != 0);
        Assert.assertTrue((cell1.getValueArray() == value1 ? 1 : 0) != 0);
        Assert.assertTrue((cell1.getTimestamp() == ts1 ? 1 : 0) != 0);
    }
}

