/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRegionLocations {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocations.class);
    ServerName sn0 = ServerName.valueOf((String)"host0", (int)10, (long)10L);
    ServerName sn1 = ServerName.valueOf((String)"host1", (int)10, (long)10L);
    ServerName sn2 = ServerName.valueOf((String)"host2", (int)10, (long)10L);
    ServerName sn3 = ServerName.valueOf((String)"host3", (int)10, (long)10L);
    HRegionInfo info0 = this.hri(0);
    HRegionInfo info1 = this.hri(1);
    HRegionInfo info2 = this.hri(2);
    HRegionInfo info9 = this.hri(9);
    long regionId1 = 1000L;
    long regionId2 = 2000L;

    @Test
    public void testSizeMethods() {
        RegionLocations list = new RegionLocations(new HRegionLocation[0]);
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        list = this.hrll(new HRegionLocation[]{null});
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        HRegionInfo info0 = this.hri(0);
        list = this.hrll(this.hrl(info0, null));
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        HRegionInfo info9 = this.hri(9);
        list = this.hrll(this.hrl(info9, null));
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        list = this.hrll(this.hrl(info0, null), this.hrl(info9, null));
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
    }

    private HRegionInfo hri(int replicaId) {
        return this.hri(this.regionId1, replicaId);
    }

    private HRegionInfo hri(long regionId, int replicaId) {
        TableName table = TableName.valueOf((String)"table");
        byte[] startKey = HConstants.EMPTY_START_ROW;
        byte[] endKey = HConstants.EMPTY_END_ROW;
        HRegionInfo info = new HRegionInfo(table, startKey, endKey, false, regionId, replicaId);
        return info;
    }

    private HRegionLocation hrl(HRegionInfo hri, ServerName sn) {
        return new HRegionLocation((RegionInfo)hri, sn);
    }

    private HRegionLocation hrl(HRegionInfo hri, ServerName sn, long seqNum) {
        return new HRegionLocation((RegionInfo)hri, sn, seqNum);
    }

    private RegionLocations hrll(HRegionLocation ... locations) {
        return new RegionLocations(locations);
    }

    @Test
    public void testRemoveByServer() {
        RegionLocations list = new RegionLocations(new HRegionLocation[0]);
        Assert.assertTrue((list == list.removeByServer(this.sn0) ? 1 : 0) != 0);
        list = this.hrll(this.hrl(this.info0, this.sn0));
        Assert.assertTrue((list == list.removeByServer(this.sn1) ? 1 : 0) != 0);
        list = list.removeByServer(this.sn0);
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        list = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1), this.hrl(this.info2, this.sn2), this.hrl(this.info9, this.sn2));
        Assert.assertTrue((list == list.removeByServer(this.sn3) ? 1 : 0) != 0);
        list = list.removeByServer(this.sn0);
        Assert.assertNull((Object)list.getRegionLocation(0));
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertNull((Object)list.getRegionLocation(5));
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(9).getServerName());
        list = this.hrll(this.hrl(this.info0, this.sn1), this.hrl(this.info1, this.sn1), this.hrl(this.info2, this.sn0), this.hrl(this.info9, this.sn0));
        list = list.removeByServer(this.sn0);
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertNull((Object)list.getRegionLocation(2));
        Assert.assertNull((Object)list.getRegionLocation(5));
        Assert.assertNull((Object)list.getRegionLocation(9));
    }

    @Test
    public void testRemove() {
        RegionLocations list = new RegionLocations(new HRegionLocation[0]);
        Assert.assertTrue((list == list.remove(this.hrl(this.info0, this.sn0)) ? 1 : 0) != 0);
        list = this.hrll(this.hrl(this.info0, this.sn0));
        Assert.assertTrue((list == list.remove(this.hrl(this.info0, this.sn1)) ? 1 : 0) != 0);
        list = list.remove(this.hrl(this.info0, this.sn0));
        Assert.assertTrue((boolean)list.isEmpty());
        list = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1), this.hrl(this.info2, this.sn2), this.hrl(this.info9, this.sn2));
        Assert.assertTrue((list == list.remove(this.hrl(this.info1, this.sn3)) ? 1 : 0) != 0);
        list = list.remove(this.hrl(this.info0, this.sn0));
        Assert.assertNull((Object)list.getRegionLocation(0));
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertNull((Object)list.getRegionLocation(5));
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(9).getServerName());
        list = list.remove(this.hrl(this.info9, this.sn2));
        Assert.assertNull((Object)list.getRegionLocation(0));
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertNull((Object)list.getRegionLocation(5));
        Assert.assertNull((Object)list.getRegionLocation(9));
        list = this.hrll(this.hrl(this.info0, this.sn1), this.hrl(this.info1, this.sn1), this.hrl(this.info2, this.sn0), this.hrl(this.info9, this.sn0));
        list = list.remove(this.hrl(this.info9, this.sn0));
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn0, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertNull((Object)list.getRegionLocation(5));
        Assert.assertNull((Object)list.getRegionLocation(9));
    }

    @Test
    public void testUpdateLocation() {
        RegionLocations list = new RegionLocations(new HRegionLocation[0]);
        list = list.updateLocation(this.hrl(this.info0, this.sn1), false, false);
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(0).getServerName());
        list = list.updateLocation(this.hrl(this.info9, this.sn3, 10L), false, false);
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(9).getServerName());
        Assert.assertEquals((long)10L, (long)list.size());
        list = list.updateLocation(this.hrl(this.info2, this.sn2, 10L), false, false);
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertEquals((long)10L, (long)list.size());
        list = list.updateLocation(this.hrl(this.info2, this.sn3, 11L), false, false);
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(9).getServerName());
        list = list.updateLocation(this.hrl(this.info2, this.sn1, 11L), false, false);
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(9).getServerName());
        list = list.updateLocation(this.hrl(this.info2, this.sn1, 11L), true, false);
        Assert.assertEquals((Object)this.sn1, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(9).getServerName());
        list = list.updateLocation(this.hrl(this.info2, this.sn2, 9L), false, true);
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(2).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list.getRegionLocation(9).getServerName());
    }

    @Test
    public void testMergeLocations() {
        RegionLocations list1 = new RegionLocations(new HRegionLocation[0]);
        RegionLocations list2 = new RegionLocations(new HRegionLocation[0]);
        Assert.assertTrue((list1 == list1.mergeLocations(list2) ? 1 : 0) != 0);
        list2 = this.hrll(this.hrl(this.info0, this.sn0));
        list1 = list1.mergeLocations(list2);
        Assert.assertEquals((Object)this.sn0, (Object)list1.getRegionLocation(0).getServerName());
        list1 = this.hrll(new HRegionLocation[0]);
        list1 = list2.mergeLocations(list1);
        Assert.assertEquals((Object)this.sn0, (Object)list1.getRegionLocation(0).getServerName());
        list1 = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1));
        list2 = this.hrll(this.hrl(this.info2, this.sn2));
        list1 = list2.mergeLocations(list1);
        Assert.assertEquals((Object)this.sn0, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn1, (Object)list1.getRegionLocation(1).getServerName());
        Assert.assertEquals((long)2L, (long)list1.size());
        list1 = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1));
        list2 = this.hrll(this.hrl(this.info2, this.sn2));
        list1 = list1.mergeLocations(list2);
        Assert.assertEquals((Object)this.sn0, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn1, (Object)list1.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(2).getServerName());
        list1 = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1));
        list2 = this.hrll(this.hrl(this.info0, this.sn2), this.hrl(this.info1, this.sn2), this.hrl(this.info9, this.sn3));
        list1 = list2.mergeLocations(list1);
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertEquals((Object)this.sn0, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn1, (Object)list1.getRegionLocation(1).getServerName());
        list1 = this.hrll(this.hrl(this.info0, this.sn0), this.hrl(this.info1, this.sn1));
        list2 = this.hrll(this.hrl(this.info0, this.sn2), this.hrl(this.info1, this.sn2), this.hrl(this.info9, this.sn3));
        list1 = list1.mergeLocations(list2);
        Assert.assertEquals((long)10L, (long)list1.size());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list1.getRegionLocation(9).getServerName());
        list1 = this.hrll(this.hrl(this.info0, this.sn0, 10L), this.hrl(this.info1, this.sn1, 10L));
        list2 = this.hrll(this.hrl(this.info0, this.sn2, 11L), this.hrl(this.info1, this.sn2, 11L), this.hrl(this.info9, this.sn3, 11L));
        list1 = list1.mergeLocations(list2);
        Assert.assertEquals((long)10L, (long)list1.size());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list1.getRegionLocation(9).getServerName());
        list1 = this.hrll(this.hrl(this.info0, this.sn0, 10L), this.hrl(this.info1, this.sn1, 10L));
        list2 = this.hrll(this.hrl(this.info0, this.sn2, 11L), this.hrl(this.info1, this.sn2, 11L), this.hrl(this.info9, this.sn3, 11L));
        list1 = list1.mergeLocations(list2);
        Assert.assertEquals((long)10L, (long)list1.size());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(0).getServerName());
        Assert.assertEquals((Object)this.sn2, (Object)list1.getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)this.sn3, (Object)list1.getRegionLocation(9).getServerName());
    }

    @Test
    public void testMergeLocationsWithDifferentRegionId() {
        HRegionInfo info0 = this.hri(this.regionId1, 0);
        HRegionInfo info1 = this.hri(this.regionId1, 1);
        HRegionInfo info2 = this.hri(this.regionId2, 2);
        RegionLocations list1 = this.hrll(this.hrl(info2, this.sn1));
        RegionLocations list2 = this.hrll(this.hrl(info0, this.sn2), this.hrl(info1, this.sn2));
        list1 = list2.mergeLocations(list1);
        Assert.assertNull((Object)list1.getRegionLocation(0));
        Assert.assertNull((Object)list1.getRegionLocation(1));
        Assert.assertNotNull((Object)list1.getRegionLocation(2));
        Assert.assertEquals((Object)this.sn1, (Object)list1.getRegionLocation(2).getServerName());
        Assert.assertEquals((long)3L, (long)list1.size());
        list1 = this.hrll(this.hrl(info2, this.sn1));
        list2 = this.hrll(this.hrl(info0, this.sn2), this.hrl(info1, this.sn2));
        list2 = list1.mergeLocations(list2);
        Assert.assertNotNull((Object)list2.getRegionLocation(0));
        Assert.assertNotNull((Object)list2.getRegionLocation(1));
        Assert.assertNull((Object)list2.getRegionLocation(2));
    }

    @Test
    public void testUpdateLocationWithDifferentRegionId() {
        HRegionInfo info0 = this.hri(this.regionId1, 0);
        HRegionInfo info1 = this.hri(this.regionId2, 1);
        HRegionInfo info2 = this.hri(this.regionId1, 2);
        RegionLocations list = new RegionLocations(new HRegionLocation[]{this.hrl(info0, this.sn1), this.hrl(info2, this.sn1)});
        list = list.updateLocation(this.hrl(info1, this.sn2), false, true);
        Assert.assertNull((Object)list.getRegionLocation(0));
        Assert.assertNotNull((Object)list.getRegionLocation(1));
        Assert.assertNull((Object)list.getRegionLocation(2));
        Assert.assertEquals((Object)this.sn2, (Object)list.getRegionLocation(1).getServerName());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testConstructWithNullElements() {
        RegionLocations list = new RegionLocations(new HRegionLocation[]{null});
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.numNonNullElements());
        list = new RegionLocations(new HRegionLocation[]{null, this.hrl(this.info1, this.sn0)});
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)list.numNonNullElements());
        list = new RegionLocations(new HRegionLocation[]{this.hrl(this.info0, this.sn0), null});
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)list.numNonNullElements());
        list = new RegionLocations(new HRegionLocation[]{null, this.hrl(this.info2, this.sn0), null, this.hrl(this.info9, this.sn0)});
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals((long)2L, (long)list.numNonNullElements());
        list = new RegionLocations(new HRegionLocation[]{null, this.hrl(this.info2, this.sn0), null, this.hrl(this.info9, this.sn0), null});
        Assert.assertEquals((long)11L, (long)list.size());
        Assert.assertEquals((long)2L, (long)list.numNonNullElements());
        list = new RegionLocations(new HRegionLocation[]{null, this.hrl(this.info2, this.sn0), null, this.hrl(this.info9, this.sn0), null, null});
        Assert.assertEquals((long)12L, (long)list.size());
        Assert.assertEquals((long)2L, (long)list.numNonNullElements());
    }
}

