/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="quarter", value="_FUNC_(date/timestamp/string) - Returns the quarter of the year for date, in the range 1 to 4.", extended="Example: > SELECT _FUNC_('2015-04-08');\n 2")
public class GenericUDFQuarter
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private final IntWritable output = new IntWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainDateConverter(arguments, 0, this.inputTypes, this.converters);
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Date date = this.getDateValue(arguments, 0, this.inputTypes, this.converters);
        if (date == null) {
            return null;
        }
        int month = date.getMonth() - 1;
        int quarter = (month + 3) / 3;
        this.output.set(quarter);
        return this.output;
    }

    @Override
    protected String getFuncName() {
        return "quarter";
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

