/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.Objects;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;

@Explain(displayName="UDTF Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class UDTFDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private GenericUDTF genericUDTF;
    private boolean outerLV;

    public UDTFDesc() {
    }

    public UDTFDesc(GenericUDTF genericUDTF, boolean outerLV) {
        this.genericUDTF = genericUDTF;
        this.outerLV = outerLV;
    }

    public GenericUDTF getGenericUDTF() {
        return this.genericUDTF;
    }

    public void setGenericUDTF(GenericUDTF genericUDTF) {
        this.genericUDTF = genericUDTF;
    }

    @Explain(displayName="function name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    @Signature
    public String getUDTFName() {
        return this.genericUDTF.toString();
    }

    public boolean isOuterLV() {
        return this.outerLV;
    }

    public void setOuterLV(boolean outerLV) {
        this.outerLV = outerLV;
    }

    @Explain(displayName="outer lateral view")
    @Signature
    public String isOuterLateralView() {
        return this.outerLV ? "true" : null;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            UDTFDesc otherDesc = (UDTFDesc)other;
            return Objects.equals(this.getUDTFName(), otherDesc.getUDTFName()) && Objects.equals(this.isOuterLateralView(), otherDesc.isOuterLateralView());
        }
        return false;
    }
}

