/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Resource plans", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowResourcePlanDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 6076076933035978545L;
    private static final String TABLE = "show_resourceplan";
    private static final String ALL_SCHEMA = "rp_name,status,query_parallelism#string,string,int";
    private static final String SINGLE_SCHEMA = "line#string";
    String resFile;
    String resourcePlanName;

    public ShowResourcePlanDesc() {
    }

    public ShowResourcePlanDesc(String rpName, Path resFile) {
        this.resourcePlanName = rpName;
        this.resFile = resFile.toString();
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }

    @Explain(displayName="resourcePlanName", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    public String getTable() {
        return TABLE;
    }

    public String getSchema(String rpName) {
        return rpName == null ? ALL_SCHEMA : SINGLE_SCHEMA;
    }
}

