/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AlterTableHandler
extends AbstractEventHandler {
    private final org.apache.hadoop.hive.metastore.api.Table before;
    private final org.apache.hadoop.hive.metastore.api.Table after;
    private final boolean isTruncateOp;
    private final Scenario scenario;

    AlterTableHandler(NotificationEvent event) throws Exception {
        super(event);
        AlterTableMessage atm = this.deserializer.getAlterTableMessage(event.getMessage());
        this.before = atm.getTableObjBefore();
        this.after = atm.getTableObjAfter();
        this.isTruncateOp = atm.getIsTruncateOp();
        this.scenario = this.scenarioType(this.before, this.after);
    }

    private Scenario scenarioType(org.apache.hadoop.hive.metastore.api.Table before, org.apache.hadoop.hive.metastore.api.Table after) {
        if (before.getDbName().equals(after.getDbName()) && before.getTableName().equals(after.getTableName())) {
            return this.isTruncateOp ? Scenario.TRUNCATE : Scenario.ALTER;
        }
        return Scenario.RENAME;
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ALTER_TABLE message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        Table qlMdTableBefore = new Table(this.before);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTableBefore, withinContext.hiveConf).booleanValue()) {
            return;
        }
        if (Scenario.ALTER == this.scenario) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
            Table qlMdTableAfter = new Table(this.after);
            Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
            EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTableAfter, null, withinContext.replicationSpec, withinContext.hiveConf);
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.event.getMessage());
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return this.scenario.dumpType();
    }

    private static enum Scenario {
        ALTER{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_ALTER_TABLE;
            }
        }
        ,
        RENAME{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_RENAME_TABLE;
            }
        }
        ,
        TRUNCATE{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_TRUNCATE_TABLE;
            }
        };


        abstract DumpType dumpType();
    }
}

