/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveReduceExpressionsRule
extends ReduceExpressionsRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveReduceExpressionsRule.class);
    public static final ReduceExpressionsRule FILTER_INSTANCE = new FilterReduceExpressionsRule(HiveFilter.class, HiveRelFactories.HIVE_BUILDER);
    public static final ReduceExpressionsRule PROJECT_INSTANCE = new ReduceExpressionsRule.ProjectReduceExpressionsRule(HiveProject.class, HiveRelFactories.HIVE_BUILDER);
    public static final ReduceExpressionsRule JOIN_INSTANCE = new ReduceExpressionsRule.JoinReduceExpressionsRule(HiveJoin.class, false, HiveRelFactories.HIVE_BUILDER);

    protected HiveReduceExpressionsRule(Class<? extends RelNode> clazz, RelBuilderFactory relBuilderFactory, String desc) {
        super(clazz, relBuilderFactory, desc);
    }

    public static class FilterReduceExpressionsRule
    extends ReduceExpressionsRule {
        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
            super(filterClass, relBuilderFactory, "ReduceExpressionsRule(Filter)");
        }

        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelMetadataQuery mq;
            RelOptPredicateList predicates;
            ArrayList expList;
            Filter filter = (Filter)call.rel(0);
            if (FilterReduceExpressionsRule.reduceExpressions((RelNode)filter, (List)(expList = Lists.newArrayList((Object[])new RexNode[]{filter.getCondition()})), (RelOptPredicateList)(predicates = (mq = call.getMetadataQuery()).getPulledUpPredicates(filter.getInput())), (boolean)true, (boolean)false)) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (reduced) {
                if (RexUtil.isNullabilityCast((RelDataTypeFactory)filter.getCluster().getTypeFactory(), (RexNode)newConditionExp)) {
                    newConditionExp = (RexNode)((RexCall)newConditionExp).getOperands().get(0);
                }
                if (newConditionExp.getType().getSqlTypeName() == SqlTypeName.NULL) {
                    newConditionExp = call.builder().cast(newConditionExp, SqlTypeName.BOOLEAN);
                }
                call.transformTo(call.builder().push(filter.getInput()).filter(new RexNode[]{newConditionExp}).build());
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    RexCall rexCall = (RexCall)newConditionExp;
                    boolean bl = reverse = rexCall.getKind() == SqlKind.NOT;
                    if (reverse) {
                        if (!(rexCall.getOperands().get(0) instanceof RexCall)) {
                            return;
                        }
                        rexCall = (RexCall)rexCall.getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, rexCall, reverse);
                }
                return;
            }
            call.getPlanner().setImportance((RelNode)filter, 0.0);
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Filter input) {
            return call.builder().push((RelNode)input).empty().build();
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, Filter filter, RexCall rexCall, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            switch (rexCall.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = (RexNode)rexCall.getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getInput());
                } else {
                    call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
                }
            }
        }
    }
}

