/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class OneNullRowInputFormat
extends NullRowsInputFormat
implements VectorizedInputFormatInterface {
    @Override
    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit split, JobConf conf, Reporter arg2) throws IOException {
        return new OneNullRowRecordReader((Configuration)conf, split);
    }

    public static class OneNullRowRecordReader
    extends NullRowsInputFormat.NullRowsRecordReader {
        protected boolean processed;

        public OneNullRowRecordReader(Configuration conf, InputSplit split) throws IOException {
            super(conf, split);
        }

        @Override
        public long getPos() throws IOException {
            return this.processed ? 1L : 0L;
        }

        @Override
        public float getProgress() throws IOException {
            return this.processed ? 1.0f : 0.0f;
        }

        @Override
        public boolean next(Object key, Object value) throws IOException {
            if (this.processed) {
                return false;
            }
            this.processed = true;
            if (this.rbCtx != null) {
                this.makeNullVrb(value, 1);
            }
            return true;
        }
    }
}

