/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprStringScalarStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private final byte[] arg2Scalar;
    private final int arg3Column;

    public IfExprStringScalarStringGroupColumn(int arg1Column, byte[] arg2Scalar, int arg3Column, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Column = arg3Column;
    }

    public IfExprStringScalarStringGroupColumn() {
        this.arg1Column = -1;
        this.arg2Scalar = null;
        this.arg3Column = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        BytesColumnVector arg3ColVector = (BytesColumnVector)batch.cols[this.arg3Column];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        if (!outputColVector.noNulls) {
            outputColVector.reset();
        }
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? false : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", val " + IfExprStringScalarStringGroupColumn.displayUtf8Bytes(this.arg2Scalar) + this.getColumnParamString(2, this.arg3Column);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

