/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorHashKeyWrapperBatch
extends VectorColumnSetInfo {
    private static final int MODEL_REFERENCES_COUNT = 7;
    private VectorExpression[] keyExpressions;
    private VectorHashKeyWrapper[] vectorHashKeyWrappers;
    private int keysFixedSize;
    private final VectorHashKeyWrapper.HashContext hashCtx = new VectorHashKeyWrapper.HashContext();

    public VectorHashKeyWrapperBatch(int keyCount) {
        super(keyCount);
    }

    public int getKeysFixedSize() {
        return this.keysFixedSize;
    }

    public VectorHashKeyWrapper[] getVectorHashKeyWrappers() {
        return this.vectorHashKeyWrappers;
    }

    public void evaluateBatch(VectorizedRowBatch batch) throws HiveException {
        LongColumnVector columnVector;
        int columnIndex;
        int keyIndex;
        int i;
        if (this.keyCount == 0) {
            return;
        }
        for (int i2 = 0; i2 < batch.size; ++i2) {
            this.vectorHashKeyWrappers[i2].clearIsNull();
        }
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (LongColumnVector)batch.cols[columnIndex];
            this.evaluateLongColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (DoubleColumnVector)batch.cols[columnIndex];
            this.evaluateDoubleColumnVector(batch, (DoubleColumnVector)columnVector, keyIndex, i);
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (BytesColumnVector)batch.cols[columnIndex];
            this.evaluateStringColumnVector(batch, (BytesColumnVector)columnVector, keyIndex, i);
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (DecimalColumnVector)batch.cols[columnIndex];
            this.evaluateDecimalColumnVector(batch, (DecimalColumnVector)columnVector, keyIndex, i);
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (TimestampColumnVector)batch.cols[columnIndex];
            this.evaluateTimestampColumnVector(batch, (TimestampColumnVector)columnVector, keyIndex, i);
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            columnVector = (IntervalDayTimeColumnVector)batch.cols[columnIndex];
            this.evaluateIntervalDayTimeColumnVector(batch, (IntervalDayTimeColumnVector)columnVector, keyIndex, i);
        }
        for (i = 0; i < batch.size; ++i) {
            this.vectorHashKeyWrappers[i].setHashKey();
        }
    }

    public void evaluateBatchGroupingSets(VectorizedRowBatch batch, boolean[] groupingSetsOverrideIsNulls) throws HiveException {
        int columnIndex;
        int r;
        int keyIndex;
        int i;
        for (int i2 = 0; i2 < batch.size; ++i2) {
            this.vectorHashKeyWrappers[i2].clearIsNull();
        }
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            LongColumnVector columnVector = (LongColumnVector)batch.cols[columnIndex];
            this.evaluateLongColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            DoubleColumnVector columnVector = (DoubleColumnVector)batch.cols[columnIndex];
            this.evaluateDoubleColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullString(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            BytesColumnVector columnVector = (BytesColumnVector)batch.cols[columnIndex];
            this.evaluateStringColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            DecimalColumnVector columnVector = (DecimalColumnVector)batch.cols[columnIndex];
            this.evaluateDecimalColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            TimestampColumnVector columnVector = (TimestampColumnVector)batch.cols[columnIndex];
            this.evaluateTimestampColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumnNum();
            IntervalDayTimeColumnVector columnVector = (IntervalDayTimeColumnVector)batch.cols[columnIndex];
            this.evaluateIntervalDayTimeColumnVector(batch, columnVector, keyIndex, i);
        }
        for (i = 0; i < batch.size; ++i) {
            this.vectorHashKeyWrappers[i].setHashKey();
        }
    }

    private void evaluateLongColumnVector(VectorizedRowBatch batch, LongColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignLongNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignLongNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignLongNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignLongNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignLongNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void evaluateDoubleColumnVector(VectorizedRowBatch batch, DoubleColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignDoubleNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignDoubleNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignDoubleNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignDoubleNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignDoubleNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void evaluateStringColumnVector(VectorizedRowBatch batch, BytesColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignStringNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignStringNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignStringNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignStringNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignStringNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void evaluateDecimalColumnVector(VectorizedRowBatch batch, DecimalColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignDecimalNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignDecimalNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignDecimalNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignDecimalNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignDecimalNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void evaluateTimestampColumnVector(VectorizedRowBatch batch, TimestampColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignTimestampNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignTimestampNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignTimestampNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignTimestampNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignTimestampNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void evaluateIntervalDayTimeColumnVector(VectorizedRowBatch batch, IntervalDayTimeColumnVector columnVector, int keyIndex, int index) {
        if (columnVector.isRepeating) {
            if (columnVector.noNulls || !columnVector.isNull[0]) {
                this.assignIntervalDayTimeNoNullsRepeating(index, batch.size, columnVector);
            } else {
                this.assignIntervalDayTimeNullsRepeating(keyIndex, index, batch.size, columnVector);
            }
        } else if (columnVector.noNulls) {
            if (batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingSelection(index, batch.size, columnVector, batch.selected);
            } else {
                this.assignIntervalDayTimeNoNullsNoRepeatingNoSelection(index, batch.size, columnVector);
            }
        } else if (batch.selectedInUse) {
            this.assignIntervalDayTimeNullsNoRepeatingSelection(keyIndex, index, batch.size, columnVector, batch.selected);
        } else {
            this.assignIntervalDayTimeNullsNoRepeatingNoSelection(keyIndex, index, batch.size, columnVector);
        }
    }

    private void assignStringNullsNoRepeatingSelection(int keyIndex, int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNullsRepeating(int keyIndex, int index, int size, BytesColumnVector columnVector) {
        if (columnVector.isNull[0]) {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
            }
        }
    }

    private void assignStringNullsNoRepeatingNoSelection(int keyIndex, int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            if (columnVector.isNull[i]) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignStringNoNullsRepeating(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
        }
    }

    private void assignStringNoNullsNoRepeatingSelection(int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNoNullsNoRepeatingNoSelection(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignDoubleNullsNoRepeatingSelection(int keyIndex, int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDouble(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNullsRepeating(int keyIndex, int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNullsNoRepeatingNoSelection(int keyIndex, int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNoNullsRepeating(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[0]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingSelection(int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingNoSelection(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
        }
    }

    private void assignLongNullsNoRepeatingSelection(int keyIndex, int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignLong(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNullsRepeating(int keyIndex, int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNullsNoRepeatingNoSelection(int keyIndex, int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNoNullsRepeating(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[0]);
        }
    }

    private void assignLongNoNullsNoRepeatingSelection(int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignLongNoNullsNoRepeatingNoSelection(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
        }
    }

    private void assignDecimalNullsNoRepeatingSelection(int keyIndex, int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDecimal(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNullsRepeating(int keyIndex, int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNullsNoRepeatingNoSelection(int keyIndex, int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNoNullsRepeating(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[0]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingSelection(int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingNoSelection(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
        }
    }

    private void assignTimestampNullsNoRepeatingSelection(int keyIndex, int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignTimestamp(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNullsRepeating(int keyIndex, int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNullsNoRepeatingNoSelection(int keyIndex, int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNoNullsRepeating(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, 0);
        }
    }

    private void assignTimestampNoNullsNoRepeatingSelection(int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, selected[r]);
        }
    }

    private void assignTimestampNoNullsNoRepeatingNoSelection(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingSelection(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignIntervalDayTime(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNullsRepeating(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingNoSelection(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNoNullsRepeating(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, 0);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingSelection(int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, selected[r]);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingNoSelection(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
        }
    }

    public static VectorHashKeyWrapperBatch compileKeyWrapperBatch(VectorExpression[] keyExpressions) throws HiveException {
        int size = keyExpressions.length;
        TypeInfo[] typeInfos = new TypeInfo[size];
        for (int i = 0; i < size; ++i) {
            typeInfos[i] = keyExpressions[i].getOutputTypeInfo();
        }
        return VectorHashKeyWrapperBatch.compileKeyWrapperBatch(keyExpressions, typeInfos);
    }

    public static VectorHashKeyWrapperBatch compileKeyWrapperBatch(VectorExpression[] keyExpressions, TypeInfo[] typeInfos) throws HiveException {
        int i;
        VectorHashKeyWrapperBatch compiledKeyWrapperBatch = new VectorHashKeyWrapperBatch(keyExpressions.length);
        compiledKeyWrapperBatch.keyExpressions = keyExpressions;
        compiledKeyWrapperBatch.keysFixedSize = 0;
        for (i = 0; i < typeInfos.length; ++i) {
            compiledKeyWrapperBatch.addKey(typeInfos[i]);
        }
        compiledKeyWrapperBatch.finishAdding();
        compiledKeyWrapperBatch.vectorHashKeyWrappers = new VectorHashKeyWrapper[1024];
        for (i = 0; i < 1024; ++i) {
            compiledKeyWrapperBatch.vectorHashKeyWrappers[i] = compiledKeyWrapperBatch.allocateKeyWrapper();
        }
        JavaDataModel model = JavaDataModel.get();
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + JavaDataModel.alignUp((long)(model.object() + model.ref() * 7 + model.primitive1()), (long)model.memoryAlign()));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForLongArrayOfSize((long)compiledKeyWrapperBatch.longIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForDoubleArrayOfSize((long)compiledKeyWrapperBatch.doubleIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForObjectArrayOfSize((long)compiledKeyWrapperBatch.stringIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForObjectArrayOfSize((long)compiledKeyWrapperBatch.decimalIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForObjectArrayOfSize((long)compiledKeyWrapperBatch.timestampIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForObjectArrayOfSize((long)compiledKeyWrapperBatch.intervalDayTimeIndices.length));
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForIntArrayOfSize((long)compiledKeyWrapperBatch.longIndices.length) * 2L);
        compiledKeyWrapperBatch.keysFixedSize = (int)((long)compiledKeyWrapperBatch.keysFixedSize + model.lengthForBooleanArrayOfSize((long)keyExpressions.length));
        return compiledKeyWrapperBatch;
    }

    public VectorHashKeyWrapper allocateKeyWrapper() {
        return VectorHashKeyWrapper.allocate(this.hashCtx, this.longIndices.length, this.doubleIndices.length, this.stringIndices.length, this.decimalIndices.length, this.timestampIndices.length, this.intervalDayTimeIndices.length, this.keyCount);
    }

    public Object getWritableKeyValue(VectorHashKeyWrapper kw, int keyIndex, VectorExpressionWriter keyOutputWriter) throws HiveException {
        if (kw.isNull(keyIndex)) {
            return null;
        }
        ColumnVector.Type columnVectorType = this.columnVectorTypes[keyIndex];
        int columnTypeSpecificIndex = this.columnTypeSpecificIndices[keyIndex];
        switch (columnVectorType) {
            case LONG: {
                return keyOutputWriter.writeValue(kw.getLongValue(columnTypeSpecificIndex));
            }
            case DOUBLE: {
                return keyOutputWriter.writeValue(kw.getDoubleValue(columnTypeSpecificIndex));
            }
            case BYTES: {
                return keyOutputWriter.writeValue(kw.getBytes(columnTypeSpecificIndex), kw.getByteStart(columnTypeSpecificIndex), kw.getByteLength(columnTypeSpecificIndex));
            }
            case DECIMAL: {
                return keyOutputWriter.writeValue(kw.getDecimal(columnTypeSpecificIndex));
            }
            case DECIMAL_64: {
                throw new RuntimeException("Getting writable for DECIMAL_64 not supported");
            }
            case TIMESTAMP: {
                return keyOutputWriter.writeValue(kw.getTimestamp(columnTypeSpecificIndex));
            }
            case INTERVAL_DAY_TIME: {
                return keyOutputWriter.writeValue(kw.getIntervalDayTime(columnTypeSpecificIndex));
            }
        }
        throw new HiveException("Unexpected column vector type " + columnVectorType);
    }

    public void setLongValue(VectorHashKeyWrapper kw, int keyIndex, Long value) throws HiveException {
        if (this.columnVectorTypes[keyIndex] != ColumnVector.Type.LONG) {
            throw new HiveException("Consistency error: expected LONG type; found: " + this.columnVectorTypes[keyIndex]);
        }
        int columnTypeSpecificIndex = this.columnTypeSpecificIndices[keyIndex];
        if (value == null) {
            kw.assignNullLong(keyIndex, columnTypeSpecificIndex);
            return;
        }
        kw.assignLong(keyIndex, columnTypeSpecificIndex, value);
    }

    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int keyIndex, VectorHashKeyWrapper kw) throws HiveException {
        ColumnVector colVector = batch.cols[keyIndex];
        if (kw.isNull(keyIndex)) {
            colVector.noNulls = false;
            colVector.isNull[batchIndex] = true;
            return;
        }
        colVector.isNull[batchIndex] = false;
        ColumnVector.Type columnVectorType = this.columnVectorTypes[keyIndex];
        int columnTypeSpecificIndex = this.columnTypeSpecificIndices[keyIndex];
        switch (columnVectorType) {
            case LONG: 
            case DECIMAL_64: {
                ((LongColumnVector)colVector).vector[batchIndex] = kw.getLongValue(columnTypeSpecificIndex);
                break;
            }
            case DOUBLE: {
                ((DoubleColumnVector)colVector).vector[batchIndex] = kw.getDoubleValue(columnTypeSpecificIndex);
                break;
            }
            case BYTES: {
                ((BytesColumnVector)colVector).setVal(batchIndex, kw.getBytes(columnTypeSpecificIndex), kw.getByteStart(columnTypeSpecificIndex), kw.getByteLength(columnTypeSpecificIndex));
                break;
            }
            case DECIMAL: {
                ((DecimalColumnVector)colVector).set(batchIndex, kw.getDecimal(columnTypeSpecificIndex));
                break;
            }
            case TIMESTAMP: {
                ((TimestampColumnVector)colVector).set(batchIndex, kw.getTimestamp(columnTypeSpecificIndex));
                break;
            }
            case INTERVAL_DAY_TIME: {
                ((IntervalDayTimeColumnVector)colVector).set(batchIndex, kw.getIntervalDayTime(columnTypeSpecificIndex));
                break;
            }
            default: {
                throw new HiveException("Unexpected column vector type " + columnVectorType);
            }
        }
    }

    public int getVariableSize(int batchSize) {
        int variableSize = 0;
        if (0 < this.stringIndices.length) {
            for (int k = 0; k < batchSize; ++k) {
                VectorHashKeyWrapper hkw = this.vectorHashKeyWrappers[k];
                variableSize += hkw.getVariableSize();
            }
        }
        return variableSize;
    }
}

