/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.Constants;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;

public class FSCountersSummary
implements PrintSummary {
    private static final String FORMATTING_PATTERN = "%10s %15s %13s %18s %18s %13s";
    private static final String HEADER = String.format("%10s %15s %13s %18s %18s %13s", "VERTICES", "BYTES_READ", "READ_OPS", "LARGE_READ_OPS", "BYTES_WRITTEN", "WRITE_OPS");
    private Map<String, Progress> progressMap;
    private DAGClient dagClient;

    FSCountersSummary(Map<String, Progress> progressMap, DAGClient dagClient) {
        this.progressMap = progressMap;
        this.dagClient = dagClient;
    }

    @Override
    public void print(SessionState.LogHelper console) {
        console.printInfo("FileSystem Counters Summary");
        TreeSet<String> keys = new TreeSet<String>(this.progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            String scheme = statistics.getScheme().toUpperCase();
            console.printInfo("");
            console.printInfo("Scheme: " + scheme);
            console.printInfo(Constants.SEPARATOR);
            console.printInfo(HEADER);
            console.printInfo(Constants.SEPARATOR);
            for (String vertexName : keys) {
                TezCounters vertexCounters = this.vertexCounters(statusOptions, vertexName);
                if (vertexCounters == null) continue;
                console.printInfo(this.summary(scheme, vertexName, vertexCounters));
            }
            console.printInfo(Constants.SEPARATOR);
        }
    }

    private String summary(String scheme, String vertexName, TezCounters vertexCounters) {
        String counterGroup = FileSystemCounter.class.getName();
        long bytesRead = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, scheme + "_" + FileSystemCounter.BYTES_READ.name());
        long bytesWritten = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, scheme + "_" + FileSystemCounter.BYTES_WRITTEN.name());
        long readOps = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, scheme + "_" + FileSystemCounter.READ_OPS.name());
        long largeReadOps = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, scheme + "_" + FileSystemCounter.LARGE_READ_OPS.name());
        long writeOps = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, scheme + "_" + FileSystemCounter.WRITE_OPS.name());
        return String.format(FORMATTING_PATTERN, vertexName, Utilities.humanReadableByteCount(bytesRead), readOps, largeReadOps, Utilities.humanReadableByteCount(bytesWritten), writeOps);
    }

    private TezCounters vertexCounters(Set<StatusGetOpts> statusOptions, String vertexName) {
        try {
            return this.dagClient.getVertexStatus(vertexName, statusOptions).getVertexCounters();
        }
        catch (IOException | TezException throwable) {
            return null;
        }
    }
}

