/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.EventUtils;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.event.filters.AndFilter;
import org.apache.hadoop.hive.metastore.messaging.event.filters.DatabaseAndTableFilter;
import org.apache.hadoop.hive.metastore.messaging.event.filters.EventBoundaryFilter;
import org.apache.hadoop.hive.metastore.messaging.event.filters.MessageFormatFilter;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandlerFactory;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.ConstraintsSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.FunctionSerializer;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.BootstrapDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.IncrementalDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.plan.ExportWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplDumpTask
extends Task<ReplDumpWork>
implements Serializable {
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";
    private static final String FUNCTIONS_ROOT_DIR_NAME = "_functions";
    private static final String CONSTRAINTS_ROOT_DIR_NAME = "_constraints";
    private static final String FUNCTION_METADATA_FILE_NAME = "_metadata";
    private static long sleepTime = 60000L;
    private Logger LOG = LoggerFactory.getLogger(ReplDumpTask.class);
    private ReplLogger replLogger;

    @Override
    public String getName() {
        return "REPL_DUMP";
    }

    @Override
    protected int execute(DriverContext driverContext) {
        try {
            Path dumpRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLDIR), this.getNextDumpDir());
            DumpMetaData dmd = new DumpMetaData(dumpRoot, this.conf);
            Path cmRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLCMDIR));
            Long lastReplId = ((ReplDumpWork)this.work).isBootStrapDump() ? this.bootStrapDump(dumpRoot, dmd, cmRoot) : this.incrementalDump(dumpRoot, dmd, cmRoot);
            this.prepareReturnValues(Arrays.asList(dumpRoot.toUri().toString(), String.valueOf(lastReplId)), dumpSchema);
        }
        catch (Exception e) {
            this.LOG.error("failed", (Throwable)e);
            this.setException(e);
            return ErrorMsg.getErrorMsg(e.getMessage()).getErrorCode();
        }
        return 0;
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        Utils.writeOutput(values, new Path(((ReplDumpWork)this.work).resultTempPath), this.conf);
    }

    private Long incrementalDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot) throws Exception {
        ((ReplDumpWork)this.work).overrideEventTo(this.getHive());
        AndFilter evFilter = new AndFilter(new IMetaStoreClient.NotificationFilter[]{new DatabaseAndTableFilter(((ReplDumpWork)this.work).dbNameOrPattern, ((ReplDumpWork)this.work).tableNameOrPattern), new EventBoundaryFilter(((ReplDumpWork)this.work).eventFrom.longValue(), ((ReplDumpWork)this.work).eventTo.longValue()), new MessageFormatFilter(MessageFactory.getInstance().getMessageFormat())});
        EventUtils.MSClientNotificationFetcher evFetcher = new EventUtils.MSClientNotificationFetcher(this.getHive().getMSC());
        EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator((EventUtils.NotificationFetcher)evFetcher, ((ReplDumpWork)this.work).eventFrom.longValue(), ((ReplDumpWork)this.work).maxEventLimit(), (IMetaStoreClient.NotificationFilter)evFilter);
        Long lastReplId = ((ReplDumpWork)this.work).eventTo;
        String dbName = null != ((ReplDumpWork)this.work).dbNameOrPattern && !((ReplDumpWork)this.work).dbNameOrPattern.isEmpty() ? ((ReplDumpWork)this.work).dbNameOrPattern : "?";
        this.replLogger = new IncrementalDumpLogger(dbName, dumpRoot.toString(), evFetcher.getDbNotificationEventsCount(((ReplDumpWork)this.work).eventFrom.longValue(), dbName));
        this.replLogger.startLog();
        while (evIter.hasNext()) {
            NotificationEvent ev = evIter.next();
            lastReplId = ev.getEventId();
            Path evRoot = new Path(dumpRoot, String.valueOf(lastReplId));
            this.dumpEvent(ev, evRoot, cmRoot);
        }
        this.replLogger.endLog(lastReplId.toString());
        this.LOG.info("Done dumping events, preparing to return {},{}", (Object)dumpRoot.toUri(), (Object)lastReplId);
        Utils.writeOutput(Arrays.asList("incremental", String.valueOf(((ReplDumpWork)this.work).eventFrom), String.valueOf(lastReplId)), dmd.getDumpFilePath(), this.conf);
        dmd.setDump(DumpType.INCREMENTAL, ((ReplDumpWork)this.work).eventFrom, lastReplId, cmRoot);
        dmd.write();
        return lastReplId;
    }

    private void dumpEvent(NotificationEvent ev, Path evRoot, Path cmRoot) throws Exception {
        EventHandler.Context context = new EventHandler.Context(evRoot, cmRoot, this.getHive(), this.conf, this.getNewEventOnlyReplicationSpec(ev.getEventId()));
        EventHandler eventHandler = EventHandlerFactory.handlerFor(ev);
        eventHandler.handle(context);
        this.replLogger.eventLog(String.valueOf(ev.getEventId()), eventHandler.dumpType().toString());
    }

    private ReplicationSpec getNewEventOnlyReplicationSpec(Long eventId) {
        ReplicationSpec rspec = this.getNewReplicationSpec(eventId.toString(), eventId.toString(), this.conf.getBoolean(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY.varname, false));
        rspec.setReplSpecType(ReplicationSpec.Type.INCREMENTAL_DUMP);
        return rspec;
    }

    private Long bootStrapDump(Path dumpRoot, DumpMetaData dmd, Path cmRoot) throws Exception {
        Hive hiveDb = this.getHive();
        Long bootDumpBeginReplId = hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
        String validTxnList = this.getValidTxnListForReplDump(hiveDb);
        for (String string : Utils.matchesDb(hiveDb, ((ReplDumpWork)this.work).dbNameOrPattern)) {
            this.LOG.debug("ReplicationSemanticAnalyzer: analyzeReplDump dumping db: " + string);
            this.replLogger = new BootstrapDumpLogger(string, dumpRoot.toString(), Utils.getAllTables(this.getHive(), string).size(), this.getHive().getAllFunctions().size());
            this.replLogger.startLog();
            Path dbRoot = this.dumpDbMetadata(string, dumpRoot, bootDumpBeginReplId);
            this.dumpFunctionMetadata(string, dumpRoot);
            String uniqueKey = Utils.setDbBootstrapDumpState(hiveDb, string);
            for (String string2 : Utils.matchesTbl(hiveDb, string, ((ReplDumpWork)this.work).tableNameOrPattern)) {
                this.LOG.debug("analyzeReplDump dumping table: " + string2 + " to db root " + dbRoot.toUri());
                this.dumpTable(string, string2, validTxnList, dbRoot);
                this.dumpConstraintMetadata(string, string2, dbRoot);
            }
            Utils.resetDbBootstrapDumpState(hiveDb, string, uniqueKey);
            this.replLogger.endLog(bootDumpBeginReplId.toString());
        }
        Long bootDumpEndReplId = hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
        this.LOG.info("Bootstrap object dump phase took from {} to {}", (Object)bootDumpBeginReplId, (Object)bootDumpEndReplId);
        DatabaseAndTableFilter databaseAndTableFilter = new DatabaseAndTableFilter(((ReplDumpWork)this.work).dbNameOrPattern, ((ReplDumpWork)this.work).tableNameOrPattern);
        EventUtils.MSClientNotificationFetcher evFetcher = new EventUtils.MSClientNotificationFetcher(hiveDb.getMSC());
        EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator((EventUtils.NotificationFetcher)evFetcher, bootDumpBeginReplId.longValue(), Ints.checkedCast((long)(bootDumpEndReplId - bootDumpBeginReplId)) + 1, (IMetaStoreClient.NotificationFilter)databaseAndTableFilter);
        while (evIter.hasNext()) {
            NotificationEvent ev = evIter.next();
            Path path = new Path(dumpRoot, String.valueOf(ev.getEventId()));
        }
        this.LOG.info("Consolidation done, preparing to return {},{}->{}", new Object[]{dumpRoot.toUri(), bootDumpBeginReplId, bootDumpEndReplId});
        dmd.setDump(DumpType.BOOTSTRAP, bootDumpBeginReplId, bootDumpEndReplId, cmRoot);
        dmd.write();
        return bootDumpBeginReplId;
    }

    private Path dumpDbMetadata(String dbName, Path dumpRoot, long lastReplId) throws Exception {
        Path dbRoot = new Path(dumpRoot, dbName);
        FileSystem fs = dbRoot.getFileSystem((Configuration)this.conf);
        Path dumpPath = new Path(dbRoot, FUNCTION_METADATA_FILE_NAME);
        HiveWrapper.Tuple<Database> database = new HiveWrapper(this.getHive(), dbName, lastReplId).database();
        EximUtil.createDbExportDump(fs, dumpPath, (Database)database.object, database.replicationSpec);
        return dbRoot;
    }

    private void dumpTable(String dbName, String tblName, String validTxnList, Path dbRoot) throws Exception {
        try {
            Hive db = this.getHive();
            HiveWrapper.Tuple<Table> tuple = new HiveWrapper(db, dbName).table(tblName);
            BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec((Table)tuple.object);
            TableExport.Paths exportPaths = new TableExport.Paths(((ReplDumpWork)this.work).astRepresentationForErrorMsg, dbRoot, tblName, this.conf, true);
            String distCpDoAsUser = this.conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
            tuple.replicationSpec.setIsReplace(true);
            if (AcidUtils.isTransactionalTable(tableSpec.tableHandle)) {
                tuple.replicationSpec.setValidWriteIdList(this.getValidWriteIdList(dbName, tblName, validTxnList));
            }
            ExportWork.MmContext mmCtx = ExportWork.MmContext.createIfNeeded(tableSpec.tableHandle);
            new TableExport(exportPaths, tableSpec, tuple.replicationSpec, db, distCpDoAsUser, this.conf, mmCtx).write();
            this.replLogger.tableLog(tblName, tableSpec.tableHandle.getTableType());
        }
        catch (InvalidTableException te) {
            this.LOG.debug(te.getMessage());
        }
    }

    private String getValidWriteIdList(String dbName, String tblName, String validTxnString) throws LockException {
        if (validTxnString == null || validTxnString.isEmpty()) {
            return null;
        }
        String fullTableName = AcidUtils.getFullTableName(dbName, tblName);
        ValidWriteIdList validWriteIds = this.getTxnMgr().getValidWriteIds(Collections.singletonList(fullTableName), validTxnString).getTableValidWriteIdList(fullTableName);
        return validWriteIds != null ? validWriteIds.toString() : null;
    }

    private List<Long> getOpenTxns(ValidTxnList validTxnList) {
        long[] invalidTxns = validTxnList.getInvalidTransactions();
        ArrayList<Long> openTxns = new ArrayList<Long>();
        for (long invalidTxn : invalidTxns) {
            if (validTxnList.isTxnAborted(invalidTxn)) continue;
            openTxns.add(invalidTxn);
        }
        return openTxns;
    }

    private String getValidTxnListForReplDump(Hive hiveDb) throws HiveException {
        ValidTxnList validTxnList = this.getTxnMgr().getValidTxns();
        long timeoutInMs = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_OPEN_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        long waitUntilTime = System.currentTimeMillis() + timeoutInMs;
        while (System.currentTimeMillis() < waitUntilTime) {
            if (this.getOpenTxns(validTxnList).isEmpty()) {
                return validTxnList.toString();
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.LOG.info("REPL DUMP thread sleep interrupted", (Throwable)e);
            }
            validTxnList = this.getTxnMgr().getValidTxns();
        }
        List<Long> openTxns = this.getOpenTxns(validTxnList);
        if (!openTxns.isEmpty()) {
            hiveDb.abortTransactions(openTxns);
            validTxnList = this.getTxnMgr().getValidTxns();
            if (validTxnList.getMinOpenTxn() != null) {
                openTxns = this.getOpenTxns(validTxnList);
                this.LOG.warn("REPL DUMP unable to force abort all the open txns: {} after timeout due to unknown reasons. However, this is rare case that shouldn't happen.", openTxns);
                throw new IllegalStateException("REPL DUMP triggered abort txns failed for unknown reasons.");
            }
        }
        return validTxnList.toString();
    }

    private ReplicationSpec getNewReplicationSpec(String evState, String objState, boolean isMetadataOnly) {
        return new ReplicationSpec(true, isMetadataOnly, evState, objState, false, true, true);
    }

    private String getNextDumpDir() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            if (ReplDumpWork.testInjectDumpDir == null) {
                return "next";
            }
            return ReplDumpWork.testInjectDumpDir;
        }
        return UUID.randomUUID().toString();
    }

    private void dumpFunctionMetadata(String dbName, Path dumpRoot) throws Exception {
        Path functionsRoot = new Path(new Path(dumpRoot, dbName), FUNCTIONS_ROOT_DIR_NAME);
        List<String> functionNames = this.getHive().getFunctions(dbName, "*");
        for (String functionName : functionNames) {
            HiveWrapper.Tuple<Function> tuple = this.functionTuple(functionName, dbName);
            if (tuple == null) continue;
            Path functionRoot = new Path(functionsRoot, functionName);
            Path functionMetadataFile = new Path(functionRoot, FUNCTION_METADATA_FILE_NAME);
            try (JsonWriter jsonWriter = new JsonWriter(functionMetadataFile.getFileSystem((Configuration)this.conf), functionMetadataFile);){
                FunctionSerializer serializer = new FunctionSerializer((Function)tuple.object, this.conf);
                serializer.writeTo(jsonWriter, tuple.replicationSpec);
            }
            this.replLogger.functionLog(functionName);
        }
    }

    private void dumpConstraintMetadata(String dbName, String tblName, Path dbRoot) throws Exception {
        block28: {
            try {
                ConstraintsSerializer serializer2;
                Throwable throwable;
                JsonWriter jsonWriter;
                Path constraintsRoot = new Path(dbRoot, CONSTRAINTS_ROOT_DIR_NAME);
                Path commonConstraintsFile = new Path(constraintsRoot, ConstraintFileType.COMMON.getPrefix() + tblName);
                Path fkConstraintsFile = new Path(constraintsRoot, ConstraintFileType.FOREIGNKEY.getPrefix() + tblName);
                Hive db = this.getHive();
                List<SQLPrimaryKey> pks = db.getPrimaryKeyList(dbName, tblName);
                List<SQLForeignKey> fks = db.getForeignKeyList(dbName, tblName);
                List<SQLUniqueConstraint> uks = db.getUniqueConstraintList(dbName, tblName);
                List<SQLNotNullConstraint> nns = db.getNotNullConstraintList(dbName, tblName);
                if (pks != null && !pks.isEmpty() || uks != null && !uks.isEmpty() || nns != null && !nns.isEmpty()) {
                    jsonWriter = new JsonWriter(commonConstraintsFile.getFileSystem((Configuration)this.conf), commonConstraintsFile);
                    throwable = null;
                    try {
                        serializer2 = new ConstraintsSerializer(pks, null, uks, nns, this.conf);
                        serializer2.writeTo(jsonWriter, null);
                    }
                    catch (Throwable serializer2) {
                        throwable = serializer2;
                        throw serializer2;
                    }
                    finally {
                        if (jsonWriter != null) {
                            if (throwable != null) {
                                try {
                                    jsonWriter.close();
                                }
                                catch (Throwable serializer2) {
                                    throwable.addSuppressed(serializer2);
                                }
                            } else {
                                jsonWriter.close();
                            }
                        }
                    }
                }
                if (fks == null || fks.isEmpty()) break block28;
                jsonWriter = new JsonWriter(fkConstraintsFile.getFileSystem((Configuration)this.conf), fkConstraintsFile);
                throwable = null;
                try {
                    serializer2 = new ConstraintsSerializer(null, fks, null, null, this.conf);
                    serializer2.writeTo(jsonWriter, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonWriter != null) {
                        if (throwable != null) {
                            try {
                                jsonWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jsonWriter.close();
                        }
                    }
                }
            }
            catch (NoSuchObjectException e) {
                this.LOG.debug(e.getMessage());
            }
        }
    }

    private HiveWrapper.Tuple<Function> functionTuple(String functionName, String dbName) {
        try {
            HiveWrapper.Tuple<Function> tuple = new HiveWrapper(this.getHive(), dbName).function(functionName);
            if (((Function)tuple.object).getResourceUris().isEmpty()) {
                this.LOG.warn("Not replicating function: " + functionName + " as it seems to have been created without USING clause");
                return null;
            }
            return tuple;
        }
        catch (HiveException e) {
            this.LOG.info("Function " + functionName + " could not be found, we are ignoring it as it can be a valid state ", (Throwable)e);
            return null;
        }
    }

    @Override
    public StageType getType() {
        return StageType.REPL_DUMP;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    public static enum ConstraintFileType {
        COMMON("common", "c_"),
        FOREIGNKEY("fk", "f_");

        private final String name;
        private final String prefix;

        private ConstraintFileType(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

