/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.stats.BasicStatsNoJobTask;
import org.apache.hadoop.hive.ql.stats.BasicStatsTask;
import org.apache.hadoop.hive.ql.stats.ColStatsProcessor;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsTask
extends Task<StatsWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(StatsTask.class);
    List<IStatsProcessor> processors = new ArrayList<IStatsProcessor>();
    private Collection<Partition> dpPartSpecs;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext ctx, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, ctx, opContext);
        if (((StatsWork)this.work).getBasicStatsWork() != null) {
            BasicStatsTask task = new BasicStatsTask(this.conf, ((StatsWork)this.work).getBasicStatsWork());
            task.followedColStats = ((StatsWork)this.work).hasColStats();
            this.processors.add(0, task);
        } else if (((StatsWork)this.work).isFooterScan()) {
            BasicStatsNoJobTask t = new BasicStatsNoJobTask(this.conf, ((StatsWork)this.work).getBasicStatsNoJobWork());
            this.processors.add(0, t);
        }
        if (((StatsWork)this.work).hasColStats()) {
            this.processors.add(new ColStatsProcessor(((StatsWork)this.work).getColStats(), this.conf));
        }
        for (IStatsProcessor p : this.processors) {
            p.initialize(opContext);
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        if (driverContext.getCtx().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        if (((StatsWork)this.work).isAggregating() && ((StatsWork)this.work).isFooterScan()) {
            throw new RuntimeException("Can not have both basic stats work and stats no job work!");
        }
        int ret = 0;
        try {
            if (((StatsWork)this.work).isFooterScan()) {
                ((StatsWork)this.work).getBasicStatsNoJobWork().setPartitions(((StatsWork)this.work).getPartitions());
            }
            Hive db = this.getHive();
            Table tbl = this.getTable(db);
            for (IStatsProcessor task : this.processors) {
                task.setDpPartSpecs(this.dpPartSpecs);
                ret = task.process(db, tbl);
                if (ret == 0) continue;
                return ret;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to run stats task", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private Table getTable(Hive db) throws SemanticException, HiveException {
        Table tbl = ((StatsWork)this.work).getTable();
        if (tbl.getSd().getLocation() == null) {
            tbl = db.getTable(((StatsWork)this.work).getFullTableName());
        }
        return tbl;
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS TASK";
    }

    @Override
    protected void receiveFeed(Task.FeedType feedType, Object feedValue) {
        if (feedType == Task.FeedType.DYNAMIC_PARTITIONS) {
            this.dpPartSpecs = (Collection)feedValue;
        }
    }

    public static ExecutorService newThreadPool(HiveConf conf) {
        int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_GATHER_NUM_THREADS);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StatsNoJobTask-Thread-%d").build());
        LOG.info("Initialized threadpool for stats computation with {} threads", (Object)numThreads);
        return executor;
    }
}

