/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFTopNHash;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hive.common.util.Murmur3;

public class ReduceSinkOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable,
TopNHash.BinaryCollector {
    private static final long serialVersionUID = 1L;
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient ObjectInspector[] bucketObjectInspectors;
    private transient int buckColIdxInKey;
    private transient int buckColIdxInKeyForSdpo = -1;
    private boolean firstRow;
    private transient int tag;
    private boolean skipTag = false;
    private transient int[] valueIndex;
    protected transient OutputCollector out;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    protected transient ExprNodeEvaluator[] bucketEval = null;
    protected transient Serializer keySerializer;
    protected transient boolean keyIsText;
    protected transient Serializer valueSerializer;
    protected transient byte[] tagByte = new byte[1];
    protected transient int numDistributionKeys;
    protected transient int numDistinctExprs;
    protected transient String[] inputAliases;
    protected transient boolean useUniformHash = false;
    protected transient TopNHash reducerHash;
    protected transient HiveKey keyWritable = new HiveKey();
    protected transient ObjectInspector keyObjectInspector;
    protected transient ObjectInspector valueObjectInspector;
    protected transient Object[] cachedValues;
    protected transient List<List<Integer>> distinctColIndices;
    protected transient Random random;
    protected transient BiFunction<Object[], ObjectInspector[], Integer> hashFunc;
    protected transient Object[][] cachedKeys;
    protected transient long cntr = 1L;
    protected transient long logEveryNRows = 0L;

    protected ReduceSinkOperator() {
    }

    public ReduceSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        try {
            int index;
            this.numRows = 0L;
            this.cntr = 1L;
            this.logEveryNRows = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOG_N_RECORDS);
            ArrayList<ExprNodeDesc> keys = ((ReduceSinkDesc)this.conf).getKeyCols();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("keys size is " + keys.size());
                for (ExprNodeDesc exprNodeDesc : keys) {
                    this.LOG.debug("Key exprNodeDesc " + exprNodeDesc.getExprString());
                }
            }
            this.keyEval = new ExprNodeEvaluator[keys.size()];
            int i = 0;
            for (ExprNodeDesc e : keys) {
                if (e instanceof ExprNodeConstantDesc && "_bucket_number".equals(((ExprNodeConstantDesc)e).getValue())) {
                    this.buckColIdxInKeyForSdpo = i;
                }
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            this.valueEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getPartitionCols()) {
                index = ExprNodeDescUtils.indexOf(e, keys);
                this.partitionEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
            }
            if (((ReduceSinkDesc)this.conf).getBucketCols() != null && !((ReduceSinkDesc)this.conf).getBucketCols().isEmpty()) {
                this.bucketEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getBucketCols().size()];
                i = 0;
                for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getBucketCols()) {
                    index = ExprNodeDescUtils.indexOf(e, keys);
                    this.bucketEval[i++] = index < 0 ? ExprNodeEvaluatorFactory.get(e) : this.keyEval[index];
                }
                this.buckColIdxInKey = ((ReduceSinkDesc)this.conf).getPartitionCols().size();
            }
            this.tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.skipTag = ((ReduceSinkDesc)this.conf).getSkipTag();
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("Using tag = " + this.tag);
            }
            TableDesc tableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)tableDesc.getDeserializerClass().newInstance();
            this.keySerializer.initialize(null, tableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)valueTableDesc.getDeserializerClass().newInstance();
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            int limit = ((ReduceSinkDesc)this.conf).getTopN();
            float memUsage = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
            if (limit >= 0 && memUsage > 0.0f) {
                this.reducerHash = ((ReduceSinkDesc)this.conf).isPTFReduceSink() ? new PTFTopNHash() : new TopNHash();
                this.reducerHash.initialize(limit, memUsage, ((ReduceSinkDesc)this.conf).isMapGroupBy(), this, this.conf, hconf);
            }
            this.useUniformHash = ((ReduceSinkDesc)this.conf).getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
            this.firstRow = true;
            boolean acidOp = ((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.UPDATE || ((ReduceSinkDesc)this.conf).getWriteType() == AcidUtils.Operation.DELETE;
            this.hashFunc = this.bucketingVersion == 2 && !acidOp ? ObjectInspectorUtils::getBucketHashCode : ObjectInspectorUtils::getBucketHashCodeOld;
        }
        catch (Exception e) {
            String msg = "Error initializing ReduceSinkOperator: " + e.getMessage();
            this.LOG.error(msg, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<List<Integer>> distinctColIndices, List<String> outputColNames, int length, ObjectInspector rowInspector) throws HiveException {
        int inspectorLen = evals.length > length ? length + 1 : evals.length;
        ArrayList<Object> sois = new ArrayList<Object>(inspectorLen);
        ObjectInspector[] fieldObjectInspectors = ReduceSinkOperator.initEvaluators(evals, 0, length, rowInspector);
        sois.addAll(Arrays.asList(fieldObjectInspectors));
        if (outputColNames.size() > length) {
            assert (distinctColIndices != null);
            ArrayList<StandardStructObjectInspector> uois = new ArrayList<StandardStructObjectInspector>();
            for (List<Integer> distinctCols : distinctColIndices) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<ObjectInspector> eois = new ArrayList<ObjectInspector>();
                int numExprs = 0;
                for (int i : distinctCols) {
                    names.add(HiveConf.getColumnInternalName((int)numExprs));
                    eois.add(evals[i].initialize(rowInspector));
                    ++numExprs;
                }
                uois.add(ObjectInspectorFactory.getStandardStructObjectInspector(names, eois));
            }
            StandardUnionObjectInspector uoi = ObjectInspectorFactory.getStandardUnionObjectInspector(uois);
            sois.add(uoi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColNames, sois);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            int firstIndex;
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info("keys are " + ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames() + " num distributions: " + ((ReduceSinkDesc)this.conf).getNumDistributionKeys());
                }
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, this.distinctColIndices, ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), this.numDistributionKeys, rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                if (this.bucketEval != null) {
                    this.bucketObjectInspectors = ReduceSinkOperator.initEvaluators(this.bucketEval, rowInspector);
                }
                int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
                int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
                this.cachedKeys = new Object[numKeys][keyLen];
                this.cachedValues = new Object[this.valueEval.length];
            }
            this.populateCachedDistributionKeys(row);
            int bucketNumber = -1;
            if (this.bucketEval != null) {
                bucketNumber = this.computeBucketNumber(row, ((ReduceSinkDesc)this.conf).getNumBuckets());
                this.cachedKeys[0][this.buckColIdxInKey] = new Text(String.valueOf(bucketNumber));
            }
            if (this.buckColIdxInKeyForSdpo != -1) {
                this.cachedKeys[0][this.buckColIdxInKeyForSdpo] = new Text(String.valueOf(bucketNumber));
            }
            HiveKey firstKey = this.toHiveKey(this.cachedKeys[0], tag, null);
            int distKeyLength = firstKey.getDistKeyLength();
            if (this.numDistinctExprs > 0) {
                this.populateCachedDistinctKeys(row, 0);
                firstKey = this.toHiveKey(this.cachedKeys[0], tag, distKeyLength);
            }
            int hashCode = this.useUniformHash && this.partitionEval.length > 0 ? this.computeMurmurHash(firstKey) : this.computeHashCode(row, bucketNumber);
            firstKey.setHashCode(hashCode);
            boolean partKeyNull = ((ReduceSinkDesc)this.conf).isPTFReduceSink() && this.partitionKeysAreNull(row);
            int n = firstIndex = this.reducerHash != null ? this.reducerHash.tryStoreKey(firstKey, partKeyNull) : -1;
            if (firstIndex == -2) {
                return;
            }
            BytesWritable value = this.makeValueWritable(row);
            if (firstIndex == -1) {
                this.collect(firstKey, (Writable)value);
            } else {
                assert (firstIndex >= 0);
                this.reducerHash.storeValue(firstIndex, firstKey.hashCode(), value, false);
            }
            for (int i = 1; i < this.numDistinctExprs; ++i) {
                System.arraycopy(this.cachedKeys[0], 0, this.cachedKeys[i], 0, this.numDistributionKeys);
                this.populateCachedDistinctKeys(row, i);
                HiveKey hiveKey = this.toHiveKey(this.cachedKeys[i], tag, distKeyLength);
                hiveKey.setHashCode(hashCode);
                this.collect(hiveKey, (Writable)value);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private int computeBucketNumber(Object row, int numBuckets) throws HiveException, SerDeException {
        Object[] bucketFieldValues = new Object[this.bucketEval.length];
        for (int i = 0; i < this.bucketEval.length; ++i) {
            bucketFieldValues[i] = this.bucketEval[i].evaluate(row);
        }
        return ObjectInspectorUtils.getBucketNumber((int)this.hashFunc.apply(bucketFieldValues, this.bucketObjectInspectors), (int)numBuckets);
    }

    private void populateCachedDistributionKeys(Object row) throws HiveException {
        for (int i = 0; i < this.numDistributionKeys; ++i) {
            this.cachedKeys[0][i] = this.keyEval[i].evaluate(row);
        }
        if (this.cachedKeys[0].length > this.numDistributionKeys) {
            this.cachedKeys[0][this.numDistributionKeys] = null;
        }
    }

    private void populateCachedDistinctKeys(Object row, int index) throws HiveException {
        StandardUnionObjectInspector.StandardUnion union = new StandardUnionObjectInspector.StandardUnion((byte)index, (Object)new Object[this.distinctColIndices.get(index).size()]);
        this.cachedKeys[index][this.numDistributionKeys] = union;
        Object[] distinctParameters = (Object[])union.getObject();
        for (int distinctParamI = 0; distinctParamI < distinctParameters.length; ++distinctParamI) {
            distinctParameters[distinctParamI] = this.keyEval[this.distinctColIndices.get(index).get(distinctParamI)].evaluate(row);
        }
        union.setTag((byte)index);
    }

    protected final int computeMurmurHash(HiveKey firstKey) {
        return Murmur3.hash32((byte[])firstKey.getBytes(), (int)firstKey.getDistKeyLength(), (int)0);
    }

    private int computeHashCode(Object row, int buckNum) throws HiveException {
        int hashCode;
        int keyHashCode = 0;
        if (this.partitionEval.length == 0) {
            if (this.random == null) {
                this.random = new Random(12345L);
            }
            keyHashCode = this.random.nextInt();
        } else {
            Object[] bucketFieldValues = new Object[this.partitionEval.length];
            for (int i = 0; i < this.partitionEval.length; ++i) {
                bucketFieldValues[i] = this.partitionEval[i].evaluate(row);
            }
            keyHashCode = this.hashFunc.apply(bucketFieldValues, this.partitionObjectInspectors);
        }
        int n = hashCode = buckNum < 0 ? keyHashCode : keyHashCode * 31 + buckNum;
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("Going to return hash code " + hashCode);
        }
        return hashCode;
    }

    private boolean partitionKeysAreNull(Object row) throws HiveException {
        if (this.partitionEval.length != 0) {
            for (int i = 0; i < this.partitionEval.length; ++i) {
                Object o = this.partitionEval[i].evaluate(row);
                if (o == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected HiveKey toHiveKey(Object obj, int tag, Integer distLength) throws SerDeException {
        BinaryComparable key = (BinaryComparable)this.keySerializer.serialize(obj, this.keyObjectInspector);
        int keyLength = key.getLength();
        if (tag == -1 || this.skipTag) {
            this.keyWritable.set(key.getBytes(), 0, keyLength);
        } else {
            this.keyWritable.setSize(keyLength + 1);
            System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
            this.keyWritable.get()[keyLength] = this.tagByte[0];
        }
        this.keyWritable.setDistKeyLength(distLength == null ? keyLength : distLength);
        return this.keyWritable;
    }

    @Override
    public void collect(byte[] key, byte[] value, int hash) throws IOException {
        HiveKey keyWritable = new HiveKey(key, hash);
        BytesWritable valueWritable = new BytesWritable(value);
        this.collect(keyWritable, (Writable)valueWritable);
    }

    protected void collect(BytesWritable keyWritable, Writable valueWritable) throws IOException {
        if (null != this.out) {
            ++this.numRows;
            ++this.runTimeNumRows;
            if (this.LOG.isTraceEnabled() && this.numRows == this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 0L;
                    this.numRows = 1L;
                }
                this.LOG.info(this.toString() + ": records written - " + this.numRows);
            }
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    private BytesWritable makeValueWritable(Object row) throws Exception {
        int length = this.valueEval.length;
        for (int i = 0; i < length; ++i) {
            this.cachedValues[i] = this.valueEval[i].evaluate(row);
        }
        return (BytesWritable)this.valueSerializer.serialize((Object)this.cachedValues, this.valueObjectInspector);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!abort && this.reducerHash != null) {
            this.reducerHash.flush();
        }
        this.runTimeNumRows = this.numRows;
        super.closeOp(abort);
        this.out = null;
        this.random = null;
        this.reducerHash = null;
        if (this.LOG.isTraceEnabled()) {
            this.LOG.info(this.toString() + ": records written - " + this.numRows);
        }
    }

    @Override
    public String getName() {
        return ReduceSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }

    public void setSkipTag(boolean value) {
        this.skipTag = value;
    }

    public void setValueIndex(int[] valueIndex) {
        this.valueIndex = valueIndex;
    }

    public int[] getValueIndex() {
        return this.valueIndex;
    }

    public void setInputAliases(String[] inputAliases) {
        this.inputAliases = inputAliases;
    }

    public String[] getInputAliases() {
        return this.inputAliases;
    }

    @Override
    public boolean getIsReduceSink() {
        return true;
    }

    @Override
    public String getReduceOutputName() {
        return ((ReduceSinkDesc)this.conf).getOutputName();
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }
}

