/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.sasl.SaslException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, LargeTests.class})
public class TestSecureIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureIPC.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    String krbKeytab;
    String krbPrincipal;
    UserGroupInformation ugi;
    Configuration clientConf;
    Configuration serverConf;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public String rpcClientImpl;
    @Parameterized.Parameter(value=1)
    public String rpcServerImpl;

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}, rpcServerImpl={1}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<String> rpcClientImpls = Arrays.asList(BlockingRpcClient.class.getName(), NettyRpcClient.class.getName());
        List<String> rpcServerImpls = Arrays.asList(SimpleRpcServer.class.getName(), NettyRpcServer.class.getName());
        for (String rpcClientImpl : rpcClientImpls) {
            for (String rpcServerImpl : rpcServerImpls) {
                params.add(new Object[]{rpcClientImpl, rpcServerImpl});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)(PRINCIPAL + "@" + KDC.getRealm()));
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setUpTest() throws Exception {
        this.krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        this.krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        this.ugi = this.loginKerberosPrincipal(this.krbKeytab, this.krbPrincipal);
        this.clientConf = HBaseKerberosUtils.getSecuredConfiguration();
        this.clientConf.set("hbase.rpc.client.impl", this.rpcClientImpl);
        this.serverConf = HBaseKerberosUtils.getSecuredConfiguration();
        this.serverConf.set("hbase.rpc.server.impl", this.rpcServerImpl);
    }

    @Test
    public void testRpcCallWithEnabledKerberosSaslAuth() throws Exception {
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi2, (Object)this.ugi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)this.ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)this.krbPrincipal, (Object)this.ugi.getUserName());
        this.callRpcService(User.create((UserGroupInformation)ugi2));
    }

    @Test
    public void testRpcFallbackToSimpleAuth() throws Exception {
        String clientUsername = "testuser";
        UserGroupInformation clientUgi = UserGroupInformation.createUserForTesting((String)clientUsername, (String[])new String[]{clientUsername});
        Assert.assertNotSame((Object)this.ugi, (Object)clientUgi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)clientUgi.getAuthenticationMethod());
        Assert.assertEquals((Object)clientUsername, (Object)clientUgi.getUserName());
        this.clientConf.set("hbase.security.authentication", "simple");
        this.serverConf.setBoolean("hbase.ipc.server.fallback-to-simple-auth-allowed", true);
        this.callRpcService(User.create((UserGroupInformation)clientUgi));
    }

    void setRpcProtection(String clientProtection, String serverProtection) {
        this.clientConf.set("hbase.rpc.protection", clientProtection);
        this.serverConf.set("hbase.rpc.protection", serverProtection);
    }

    @Test
    public void testSaslWithCommonQop() throws Exception {
        this.setRpcProtection("privacy,authentication", "authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("integrity,authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("integrity,authentication", "integrity,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("privacy,authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
    }

    @Test
    public void testSaslNoCommonQop() throws Exception {
        this.exception.expect(SaslException.class);
        this.exception.expectMessage("No common protection layer between client and server");
        this.setRpcProtection("integrity", "privacy");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
    }

    @Test
    public void testSaslWithCryptoAES() throws Exception {
        this.setRpcProtection("privacy", "privacy");
        this.setCryptoAES("true", "true");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
    }

    @Test
    public void testDifferentConfWithCryptoAES() throws Exception {
        this.setRpcProtection("privacy", "privacy");
        this.setCryptoAES("false", "true");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setCryptoAES("true", "false");
        try {
            this.callRpcService(User.create((UserGroupInformation)this.ugi));
            Assert.fail((String)"The exception should be thrown out for the rpc timeout.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setCryptoAES(String clientCryptoAES, String serverCryptoAES) {
        this.clientConf.set("hbase.rpc.crypto.encryption.aes.enabled", clientCryptoAES);
        this.serverConf.set("hbase.rpc.crypto.encryption.aes.enabled", serverCryptoAES);
    }

    private UserGroupInformation loginKerberosPrincipal(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)cnf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRpcService(User clientUser) throws Exception {
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
        InetSocketAddress isa = new InetSocketAddress(HOST, 0);
        RpcServer rpcServer = RpcServerFactory.createRpcServer(null, (String)"AbstractTestSecureIPC", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)isa, (Configuration)this.serverConf, (RpcScheduler)new FifoRpcScheduler(this.serverConf, 1));
        rpcServer.start();
        try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)this.clientConf, (String)HConstants.DEFAULT_CLUSTER_ID.toString());){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(rpcClient, rpcServer.getListenerAddress(), clientUser);
            TestThread th1 = new TestThread(stub);
            final Throwable[] exception = new Throwable[1];
            Collections.synchronizedList(new ArrayList());
            Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread th, Throwable ex) {
                    exception[0] = ex;
                }
            };
            th1.setUncaughtExceptionHandler(exceptionHandler);
            th1.start();
            th1.join();
            if (exception[0] != null) {
                while (exception[0].getCause() != null) {
                    exception[0] = exception[0].getCause();
                }
                throw (Exception)exception[0];
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    static {
        HOST = "localhost";
    }

    public static class TestThread
    extends Thread {
        private final TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;

        public TestThread(TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub) {
            this.stub = stub;
        }

        @Override
        public void run() {
            try {
                int[] messageSize = new int[]{100, 1000, 10000};
                for (int i = 0; i < messageSize.length; ++i) {
                    String input = RandomStringUtils.random((int)messageSize[i]);
                    String result = this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage(input).build()).getMessage();
                    Assert.assertEquals((Object)input, (Object)result);
                }
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

