/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterStatusServlet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterStatusServlet.class);
    private HMaster master;
    private Configuration conf;
    private Admin admin;
    static final ServerName FAKE_HOST = ServerName.valueOf((String)"fakehost", (int)12345, (long)1234567890L);
    static final HTableDescriptor FAKE_TABLE = new HTableDescriptor(TableName.valueOf((String)"mytable"));
    static final HRegionInfo FAKE_HRI = new HRegionInfo(FAKE_TABLE.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));

    @Before
    public void setupBasicMocks() {
        this.conf = HBaseConfiguration.create();
        this.master = (HMaster)Mockito.mock(HMaster.class);
        ((HMaster)Mockito.doReturn((Object)FAKE_HOST).when((Object)this.master)).getServerName();
        ((HMaster)Mockito.doReturn((Object)this.conf).when((Object)this.master)).getConfiguration();
        DeadServer deadServer = (DeadServer)Mockito.mock(DeadServer.class);
        ServerManager serverManager = (ServerManager)Mockito.mock(ServerManager.class);
        ((ServerManager)Mockito.doReturn((Object)1.0).when((Object)serverManager)).getAverageLoad();
        ((HMaster)Mockito.doReturn((Object)serverManager).when((Object)this.master)).getServerManager();
        ((ServerManager)Mockito.doReturn((Object)deadServer).when((Object)serverManager)).getDeadServers();
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        RegionStates rs = (RegionStates)Mockito.mock(RegionStates.class);
        ArrayList<RegionState> regionsInTransition = new ArrayList<RegionState>();
        regionsInTransition.add(new RegionState((RegionInfo)FAKE_HRI, RegionState.State.CLOSING, 12345L, FAKE_HOST));
        ((AssignmentManager)Mockito.doReturn((Object)rs).when((Object)am)).getRegionStates();
        ((RegionStates)Mockito.doReturn(regionsInTransition).when((Object)rs)).getRegionsInTransition();
        ((HMaster)Mockito.doReturn((Object)am).when((Object)this.master)).getAssignmentManager();
        ((HMaster)Mockito.doReturn((Object)serverManager).when((Object)this.master)).getServerManager();
        ZKWatcher zkw = (ZKWatcher)Mockito.mock(ZKWatcher.class);
        ((ZKWatcher)Mockito.doReturn((Object)new ZNodePaths(this.conf)).when((Object)zkw)).getZNodePaths();
        ((ZKWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HMaster)Mockito.doReturn((Object)zkw).when((Object)this.master)).getZooKeeper();
        MasterAddressTracker tracker = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
        ((HMaster)Mockito.doReturn((Object)tracker).when((Object)this.master)).getMasterAddressTracker();
        ((MasterAddressTracker)Mockito.doReturn((Object)FAKE_HOST).when((Object)tracker)).getMasterAddress();
        MetricsRegionServer rms = (MetricsRegionServer)Mockito.mock(MetricsRegionServer.class);
        ((MetricsRegionServer)Mockito.doReturn((Object)new MetricsRegionServerWrapperStub()).when((Object)rms)).getRegionServerWrapper();
        ((HMaster)Mockito.doReturn((Object)rms).when((Object)this.master)).getMetrics();
        this.admin = (Admin)Mockito.mock(Admin.class);
    }

    private void setupMockTables() throws IOException {
        HTableDescriptor[] tables = new HTableDescriptor[]{new HTableDescriptor(TableName.valueOf((String)"foo")), new HTableDescriptor(TableName.valueOf((String)"bar"))};
        ((Admin)Mockito.doReturn((Object)tables).when((Object)this.admin)).listTables();
    }

    @Test
    public void testStatusTemplateNoTables() throws IOException {
        new MasterStatusTmpl().render((Writer)new StringWriter(), this.master);
    }

    @Test
    public void testStatusTemplateMetaAvailable() throws IOException {
        this.setupMockTables();
        new MasterStatusTmpl().setMetaLocation(ServerName.valueOf((String)"metaserver,123,12345")).render((Writer)new StringWriter(), this.master);
    }

    @Test
    public void testStatusTemplateWithServers() throws IOException {
        this.setupMockTables();
        ArrayList servers = Lists.newArrayList((Object[])new ServerName[]{ServerName.valueOf((String)"rootserver,123,12345"), ServerName.valueOf((String)"metaserver,123,12345")});
        HashSet deadServers = new HashSet(Lists.newArrayList((Object[])new ServerName[]{ServerName.valueOf((String)"badserver,123,12345"), ServerName.valueOf((String)"uglyserver,123,12345")}));
        new MasterStatusTmpl().setMetaLocation(ServerName.valueOf((String)"metaserver,123,12345")).setServers((List)servers).setDeadServers(deadServers).render((Writer)new StringWriter(), this.master);
    }
}

