/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestClusterStatusPublisher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterStatusPublisher.class);
    private ManualEnvironmentEdge mee = new ManualEnvironmentEdge();

    @Before
    public void before() {
        this.mee.setValue(0L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.mee);
    }

    @Test
    public void testEmpty() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                return new ArrayList<Pair<ServerName, Long>>();
            }
        };
        Assert.assertTrue((boolean)csp.generateDeadServersListToSend().isEmpty());
    }

    @Test
    public void testMaxSend() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>();
                switch ((int)EnvironmentEdgeManager.currentTime()) {
                    case 2: {
                        res.add((Pair<ServerName, Long>)new Pair((Object)ServerName.valueOf((String)"hn", (int)10, (long)10L), (Object)1L));
                        break;
                    }
                }
                return res;
            }
        };
        this.mee.setValue(2L);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)1L, (long)csp.generateDeadServersListToSend().size());
        }
        this.mee.setValue(1000L);
        Assert.assertTrue((boolean)csp.generateDeadServersListToSend().isEmpty());
    }

    @Test
    public void testOrder() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>();
                for (int i = 0; i < 25; ++i) {
                    res.add((Pair<ServerName, Long>)new Pair((Object)ServerName.valueOf((String)("hn" + i), (int)10, (long)10L), (Object)20L));
                }
                return res;
            }
        };
        this.mee.setValue(3L);
        List allSNS = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)10L);
        Assert.assertEquals((long)10L, (long)allSNS.size());
        List nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)20L, (long)allSNS.size());
        nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)25L, (long)allSNS.size());
        nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)25L, (long)allSNS.size());
    }
}

