/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestClientTimeouts {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientTimeouts.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static int SLAVES = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", RandomTimeoutRpcClient.class.getName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminTimeout() throws Exception {
        boolean lastFailed = false;
        int initialInvocations = RandomTimeoutBlockingRpcChannel.invokations.get();
        try (RandomTimeoutRpcClient rpcClient = (RandomTimeoutRpcClient)RpcClientFactory.createClient((Configuration)TEST_UTIL.getConfiguration(), (String)TEST_UTIL.getClusterKey());){
            for (int i = 0; i < 5 || lastFailed && i < 100; ++i) {
                lastFailed = false;
                Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
                conf.set("hbase.client.instance.id", String.valueOf(-1));
                Admin admin = null;
                Connection connection = null;
                try {
                    connection = ConnectionFactory.createConnection((Configuration)conf);
                    admin = connection.getAdmin();
                    HBaseAdmin.available((Configuration)conf);
                    admin.setBalancerRunning(false, false);
                    continue;
                }
                catch (MasterNotRunningException ex) {
                    lastFailed = true;
                    continue;
                }
                finally {
                    if (admin != null) {
                        admin.close();
                        if (admin.getConnection().isClosed()) {
                            rpcClient = (RandomTimeoutRpcClient)RpcClientFactory.createClient((Configuration)TEST_UTIL.getConfiguration(), (String)TEST_UTIL.getClusterKey());
                        }
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            Assert.assertFalse((boolean)lastFailed);
            Assert.assertTrue((RandomTimeoutBlockingRpcChannel.invokations.get() > initialInvocations ? 1 : 0) != 0);
        }
    }

    private static class RandomTimeoutRpcChannel
    extends AbstractRpcClient.RpcChannelImplementation {
        RandomTimeoutRpcChannel(AbstractRpcClient<?> rpcClient, ServerName sn, User ticket, int rpcTimeout) throws UnknownHostException {
            super(rpcClient, new InetSocketAddress(sn.getHostname(), sn.getPort()), ticket, rpcTimeout);
        }

        public void callMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType, RpcCallback<Message> done) {
            RandomTimeoutBlockingRpcChannel.invokations.getAndIncrement();
            if ((double)ThreadLocalRandom.current().nextFloat() < 0.3) {
                ((HBaseRpcController)controller).setFailed((IOException)new SocketTimeoutException("fake timeout"));
                done.run(null);
                return;
            }
            super.callMethod(md, controller, param, returnType, done);
        }
    }

    static class RandomTimeoutBlockingRpcChannel
    extends AbstractRpcClient.BlockingRpcChannelImplementation {
        private static final Random RANDOM = new Random(System.currentTimeMillis());
        public static final double CHANCE_OF_TIMEOUT = 0.3;
        private static AtomicInteger invokations = new AtomicInteger();

        RandomTimeoutBlockingRpcChannel(BlockingRpcClient rpcClient, ServerName sn, User ticket, int rpcTimeout) {
            super((AbstractRpcClient)rpcClient, new InetSocketAddress(sn.getHostname(), sn.getPort()), ticket, rpcTimeout);
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            invokations.getAndIncrement();
            if ((double)RANDOM.nextFloat() < 0.3) {
                throw new ServiceException((Throwable)new SocketTimeoutException("fake timeout"));
            }
            return super.callBlockingMethod(md, controller, param, returnType);
        }
    }

    public static class RandomTimeoutRpcClient
    extends BlockingRpcClient {
        public RandomTimeoutRpcClient(Configuration conf, String clusterId, SocketAddress localAddr, MetricsConnection metrics) {
            super(conf, clusterId, localAddr, metrics);
        }

        public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int rpcTimeout) throws UnknownHostException {
            return new RandomTimeoutBlockingRpcChannel(this, sn, ticket, rpcTimeout);
        }

        public RpcChannel createRpcChannel(ServerName sn, User ticket, int rpcTimeout) throws UnknownHostException {
            return new RandomTimeoutRpcChannel((AbstractRpcClient<?>)this, sn, ticket, rpcTimeout);
        }
    }
}

