/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientClusterStatus {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientClusterStatus.class);
    private static HBaseTestingUtility UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 5;
    private static final int MASTERS = 3;
    private static MiniHBaseCluster CLUSTER;
    private static HRegionServer DEAD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.master.classes", MyObserver.class.getName());
        UTIL = new HBaseTestingUtility(conf);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(3).numRegionServers(5).numDataNodes(5).build();
        UTIL.startMiniCluster(option);
        CLUSTER = UTIL.getHBaseCluster();
        CLUSTER.waitForActiveAndReadyMaster();
        ADMIN = UTIL.getAdmin();
        List<JVMClusterUtil.RegionServerThread> rsts = CLUSTER.getLiveRegionServerThreads();
        JVMClusterUtil.RegionServerThread rst = rsts.get(rsts.size() - 1);
        DEAD = rst.getRegionServer();
        DEAD.stop("Test dead servers status");
        while (rst.isAlive()) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testDefaults() throws Exception {
        ClusterStatus origin = ADMIN.getClusterStatus();
        ClusterStatus defaults = new ClusterStatus(ADMIN.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class)));
        TestClientClusterStatus.checkPbObjectNotNull(origin);
        TestClientClusterStatus.checkPbObjectNotNull(defaults);
        Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
        Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
        Assert.assertTrue((origin.getAverageLoad() == defaults.getAverageLoad() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getBackupMastersSize() == defaults.getBackupMastersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getDeadServersSize() == defaults.getDeadServersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getRegionsCount() == defaults.getRegionsCount() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getServersSize() == defaults.getServersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getMasterInfoPort() == defaults.getMasterInfoPort() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)origin.equals((Object)defaults));
        Assert.assertTrue((origin.getServersName().size() == defaults.getServersName().size() ? 1 : 0) != 0);
    }

    @Test
    public void testNone() throws Exception {
        ClusterMetrics status0 = ADMIN.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
        ClusterMetrics status1 = ADMIN.getClusterMetrics(EnumSet.noneOf(ClusterMetrics.Option.class));
        Assert.assertEquals((long)status0.getLiveServerMetrics().size(), (long)status1.getLiveServerMetrics().size());
        TestClientClusterStatus.checkPbObjectNotNull(new ClusterStatus(status0));
        TestClientClusterStatus.checkPbObjectNotNull(new ClusterStatus(status1));
    }

    @Test
    public void testLiveAndDeadServersStatus() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionserverThreads = CLUSTER.getLiveRegionServerThreads();
        int numRs = 0;
        int len = regionserverThreads.size();
        for (int i = 0; i < len; ++i) {
            if (!regionserverThreads.get(i).isAlive()) continue;
            ++numRs;
        }
        Waiter.waitFor((Configuration)CLUSTER.getConfiguration(), (long)10000L, (long)100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ClusterStatus status = new ClusterStatus(ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)));
                Assert.assertNotNull((Object)status);
                return status.getRegionsCount() > 0;
            }
        });
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.DEAD_SERVERS, ClusterMetrics.Option.SERVERS_NAME);
        ClusterStatus status = new ClusterStatus(ADMIN.getClusterMetrics(options));
        TestClientClusterStatus.checkPbObjectNotNull(status);
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getServers());
        Assert.assertEquals((long)4L, (long)numRs);
        Assert.assertEquals((long)status.getServers().size(), (long)numRs);
        Assert.assertTrue((status.getRegionsCount() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getDeadServerNames());
        Assert.assertEquals((long)1L, (long)status.getDeadServersSize());
        ServerName deadServerName = (ServerName)status.getDeadServerNames().iterator().next();
        Assert.assertEquals((Object)DEAD.getServerName(), (Object)deadServerName);
        Assert.assertNotNull((Object)status.getServersName());
        Assert.assertEquals((long)numRs, (long)status.getServersName().size());
    }

    @Test
    public void testMasterAndBackupMastersStatus() throws Exception {
        List<JVMClusterUtil.MasterThread> masterThreads = CLUSTER.getMasterThreads();
        int numActive = 0;
        int activeIndex = 0;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertNotNull(active);
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS);
        ClusterStatus status = new ClusterStatus(ADMIN.getClusterMetrics(options));
        Assert.assertTrue((boolean)status.getMaster().equals((Object)activeName));
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
    }

    @Test
    public void testOtherStatusInfos() throws Exception {
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS, ClusterMetrics.Option.HBASE_VERSION, ClusterMetrics.Option.CLUSTER_ID, ClusterMetrics.Option.BALANCER_ON);
        ClusterStatus status = new ClusterStatus(ADMIN.getClusterMetrics(options));
        Assert.assertTrue((status.getMasterCoprocessors().length == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getHBaseVersion());
        Assert.assertNotNull((Object)status.getClusterId());
        Assert.assertTrue((status.getAverageLoad() == 0.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getBalancerOn());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testObserver() throws IOException {
        int preCount = MyObserver.PRE_COUNT.get();
        int postCount = MyObserver.POST_COUNT.get();
        Assert.assertTrue((boolean)Stream.of(ADMIN.getClusterStatus().getMasterCoprocessors()).anyMatch(s -> s.equals(MyObserver.class.getSimpleName())));
        Assert.assertEquals((long)(preCount + 1), (long)MyObserver.PRE_COUNT.get());
        Assert.assertEquals((long)(postCount + 1), (long)MyObserver.POST_COUNT.get());
    }

    private static void checkPbObjectNotNull(ClusterStatus status) {
        for (ServerName name : status.getLiveServerMetrics().keySet()) {
            ServerLoad load = status.getLoad(name);
            Assert.assertNotNull((Object)load.obtainServerLoadPB());
            for (RegionLoad rl : load.getRegionsLoad().values()) {
                Assert.assertNotNull((Object)rl.regionLoadPB);
            }
        }
    }

    public static class MyObserver
    implements MasterCoprocessor,
    MasterObserver {
        private static final AtomicInteger PRE_COUNT = new AtomicInteger(0);
        private static final AtomicInteger POST_COUNT = new AtomicInteger(0);

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            PRE_COUNT.incrementAndGet();
        }

        public void postGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx, ClusterMetrics status) throws IOException {
            POST_COUNT.incrementAndGet();
        }
    }
}

