/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LessThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.NotEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POIsNull;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONot;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POOr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POOptimizedForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.pen.Illustrator;
import org.apache.pig.pen.util.LineageTracer;

public class IllustratorAttacher
extends PhyPlanVisitor {
    PigContext pigContext;
    LineageTracer lineage;
    HashMap<PhysicalOperator, Collection<IdentityHashSet<Tuple>>> poToEqclassesMap;
    private HashMap<PhysicalOperator, DataBag> poToDataMap;
    private int maxRecords;
    private boolean revisit = false;
    private ArrayList<Boolean[]> subExpResults = null;
    private final Map<POLoad, LogicalSchema> poloadToSchemaMap;

    public IllustratorAttacher(PhysicalPlan plan, LineageTracer lineage, int maxRecords, Map<POLoad, LogicalSchema> poLoadToSchemaMap, PigContext hadoopPigContext) throws VisitorException {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        this.pigContext = hadoopPigContext;
        this.lineage = lineage;
        this.poToEqclassesMap = new HashMap();
        this.poToDataMap = new HashMap();
        this.maxRecords = maxRecords;
        this.poloadToSchemaMap = poLoadToSchemaMap;
    }

    public void revisit(PhysicalPlan plan) throws VisitorException {
        this.pushWalker(new DepthFirstWalker(plan));
        this.revisit = true;
        PhysicalPlan oriPlan = (PhysicalPlan)this.mPlan;
        this.mPlan = plan;
        this.visit();
        this.mPlan = oriPlan;
        this.popWalker();
    }

    private void setIllustrator(PhysicalOperator po, int nEqClasses) {
        if (this.revisit && po.getIllustrator() != null) {
            return;
        }
        LinkedList<IdentityHashSet<Tuple>> eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        this.poToEqclassesMap.put(po, eqClasses);
        for (int i = 0; i < nEqClasses; ++i) {
            IdentityHashSet eqClass = new IdentityHashSet();
            eqClasses.add(eqClass);
        }
        Illustrator illustrator = new Illustrator(this.lineage, eqClasses, this, this.pigContext);
        po.setIllustrator(illustrator);
        this.poToDataMap.put(po, illustrator.getData());
    }

    private void setIllustrator(PhysicalOperator po, LinkedList<IdentityHashSet<Tuple>> eqClasses) {
        if (this.revisit && po.getIllustrator() != null) {
            return;
        }
        Illustrator illustrator = new Illustrator(this.lineage, eqClasses, this, this.pigContext);
        po.setIllustrator(illustrator);
        if (eqClasses != null) {
            this.poToEqclassesMap.put(po, eqClasses);
        }
        this.poToDataMap.put(po, illustrator.getData());
    }

    void setIllustrator(PhysicalOperator po) {
        if (this.revisit && po.getIllustrator() != null) {
            return;
        }
        LinkedList<IdentityHashSet<Tuple>> eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        IdentityHashSet eqClass = new IdentityHashSet();
        eqClasses.add(eqClass);
        Illustrator illustrator = new Illustrator(this.lineage, eqClasses, this, this.pigContext);
        po.setIllustrator(illustrator);
        this.poToEqclassesMap.put(po, eqClasses);
        this.poToDataMap.put(po, illustrator.getData());
    }

    public Map<PhysicalOperator, DataBag> getDataMap() {
        return this.poToDataMap;
    }

    @Override
    public void visitLoad(POLoad ld) throws VisitorException {
        if (this.revisit) {
            return;
        }
        LinkedList<IdentityHashSet<Tuple>> eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        this.poToEqclassesMap.put(ld, eqClasses);
        IdentityHashSet eqClass = new IdentityHashSet();
        eqClasses.add(eqClass);
        Illustrator illustrator = new Illustrator(this.lineage, eqClasses, this.maxRecords, this, this.poloadToSchemaMap.get(ld), this.pigContext);
        ld.setIllustrator(illustrator);
        this.poToDataMap.put(ld, illustrator.getData());
    }

    @Override
    public void visitStore(POStore st) throws VisitorException {
        this.setIllustrator((PhysicalOperator)st, 1);
    }

    @Override
    public void visitFilter(POFilter fl) throws VisitorException {
        this.setIllustrator((PhysicalOperator)fl, 0);
        this.subExpResults = fl.getIllustrator().getSubExpResults();
        this.innerPlanAttach(fl, fl.getPlan());
        this.subExpResults = null;
    }

    @Override
    public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
        super.visitLocalRearrange(lr);
        this.setIllustrator(lr);
    }

    @Override
    public void visitPackage(POPackage pkg) throws VisitorException {
        this.setIllustrator((PhysicalOperator)pkg, pkg.numberOfEquivalenceClasses());
    }

    @Override
    public void visitPOForEach(POForEach nfe) throws VisitorException {
        if (this.revisit && nfe.getIllustrator() != null) {
            return;
        }
        List<PhysicalPlan> innerPlans = nfe.getInputPlans();
        for (PhysicalPlan innerPlan : innerPlans) {
            this.innerPlanAttach(nfe, innerPlan);
        }
        List<POForEach> preds = ((PhysicalPlan)this.mPlan).getPredecessors(nfe);
        if (preds != null && preds.size() == 1 && preds.get(0) instanceof POPackage && ((POPackage)((Object)preds.get(0))).getPkgr().isDistinct()) {
            this.setIllustrator((PhysicalOperator)nfe, ((PhysicalOperator)preds.get(0)).getIllustrator().getEquivalenceClasses());
            nfe.getIllustrator().setEqClassesShared();
        } else {
            this.setIllustrator((PhysicalOperator)nfe, 1);
        }
    }

    @Override
    public void visitUnion(POUnion un) throws VisitorException {
        if (this.revisit && un.getIllustrator() != null) {
            return;
        }
        this.setIllustrator((PhysicalOperator)un, null);
    }

    @Override
    public void visitSplit(POSplit spl) throws VisitorException {
        if (this.revisit && spl.getIllustrator() != null) {
            return;
        }
        for (PhysicalPlan poPlan : spl.getPlans()) {
            this.innerPlanAttach(spl, poPlan);
        }
        this.setIllustrator(spl);
    }

    @Override
    public void visitDemux(PODemux demux) throws VisitorException {
        if (this.revisit && demux.getIllustrator() != null) {
            return;
        }
        List<PhysicalPlan> innerPlans = demux.getPlans();
        for (PhysicalPlan innerPlan : innerPlans) {
            this.innerPlanAttach(demux, innerPlan);
        }
        this.setIllustrator(demux);
    }

    @Override
    public void visitDistinct(PODistinct distinct) throws VisitorException {
        this.setIllustrator((PhysicalOperator)distinct, 1);
    }

    @Override
    public void visitSort(POSort sort) throws VisitorException {
        this.setIllustrator((PhysicalOperator)sort, 1);
    }

    @Override
    public void visitRank(PORank rank) throws VisitorException {
        this.setIllustrator((PhysicalOperator)rank, 3);
    }

    @Override
    public void visitCounter(POCounter counter) throws VisitorException {
        this.setIllustrator((PhysicalOperator)counter, 1);
    }

    @Override
    public void visitProject(POProject proj) throws VisitorException {
    }

    @Override
    public void visitGreaterThan(GreaterThanExpr grt) throws VisitorException {
        this.setIllustrator((PhysicalOperator)grt, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(grt.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitLessThan(LessThanExpr lt) throws VisitorException {
        this.setIllustrator((PhysicalOperator)lt, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(lt.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitGTOrEqual(GTOrEqualToExpr gte) throws VisitorException {
        this.setIllustrator((PhysicalOperator)gte, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(gte.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitLTOrEqual(LTOrEqualToExpr lte) throws VisitorException {
        this.setIllustrator((PhysicalOperator)lte, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(lte.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitEqualTo(EqualToExpr eq) throws VisitorException {
        this.setIllustrator((PhysicalOperator)eq, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(eq.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitNotEqualTo(NotEqualToExpr eq) throws VisitorException {
        this.setIllustrator((PhysicalOperator)eq, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(eq.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitRegexp(PORegexp re) throws VisitorException {
        this.setIllustrator((PhysicalOperator)re, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(re.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitIsNull(POIsNull isNull) throws VisitorException {
        this.setIllustrator((PhysicalOperator)isNull, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(isNull.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitAnd(POAnd and) throws VisitorException {
        this.setIllustrator((PhysicalOperator)and, 0);
    }

    @Override
    public void visitOr(POOr or) throws VisitorException {
        this.setIllustrator((PhysicalOperator)or, 0);
    }

    @Override
    public void visitNot(PONot not) throws VisitorException {
        this.setIllustrator((PhysicalOperator)not, 0);
        if (!this.revisit && this.subExpResults != null) {
            this.subExpResults.add(not.getIllustrator().getSubExpResult());
        }
    }

    @Override
    public void visitBinCond(POBinCond binCond) {
    }

    @Override
    public void visitNegative(PONegative negative) {
        this.setIllustrator((PhysicalOperator)negative, 1);
    }

    @Override
    public void visitUserFunc(POUserFunc userFunc) throws VisitorException {
    }

    @Override
    public void visitComparisonFunc(POUserComparisonFunc compFunc) throws VisitorException {
        this.setIllustrator((PhysicalOperator)compFunc, 3);
    }

    @Override
    public void visitMapLookUp(POMapLookUp mapLookUp) {
        this.setIllustrator((PhysicalOperator)mapLookUp, 1);
    }

    @Override
    public void visitCast(POCast cast) {
    }

    @Override
    public void visitLimit(POLimit lim) throws VisitorException {
        this.setIllustrator((PhysicalOperator)lim, 1);
    }

    @Override
    public void visitStream(POStream stream) throws VisitorException {
        this.setIllustrator((PhysicalOperator)stream, 1);
    }

    @Override
    public void visitPOOptimizedForEach(POOptimizedForEach optimizedForEach) throws VisitorException {
        this.visitPOForEach(optimizedForEach);
    }

    private void innerPlanAttach(PhysicalOperator po, PhysicalPlan plan) throws VisitorException {
        PlanWalker<PhysicalOperator, PhysicalPlan> childWalker = this.mCurrentWalker.spawnChildWalker(plan);
        this.pushWalker(childWalker);
        childWalker.walk(this);
        this.popWalker();
        LinkedList<IdentityHashSet<Tuple>> eqClasses = new LinkedList<IdentityHashSet<Tuple>>();
        if (this.subExpResults != null && !this.revisit) {
            int size = 1 << this.subExpResults.size();
            for (int i = 0; i < size; ++i) {
                eqClasses.add(new IdentityHashSet());
            }
            po.getIllustrator().setEquivalenceClasses(eqClasses, po);
        }
    }
}

