/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class ProjectStarExpanderUtil {
    static Pair<Integer, Integer> getProjectStartEndCols(LogicalExpressionPlan expPlan, ProjectExpression proj) throws FrontendException {
        int lastProjCol;
        int firstProjCol;
        LogicalRelationalOperator relOp = proj.getAttachedRelationalOp();
        List<Operator> inputRels = relOp.getPlan().getPredecessors(relOp);
        LogicalRelationalOperator inputRel = (LogicalRelationalOperator)inputRels.get(proj.getInputNum());
        LogicalSchema inputSchema = inputRel.getSchema();
        if (inputSchema == null && (proj.isProjectStar() || proj.isRangeProject() && proj.getEndCol() == -1)) {
            return null;
        }
        if (proj.isRangeProject()) {
            proj.setColumnNumberFromAlias();
            firstProjCol = proj.getStartCol();
            lastProjCol = proj.getEndCol() >= 0 ? proj.getEndCol() : inputSchema.size() - 1;
        } else {
            firstProjCol = 0;
            lastProjCol = inputSchema.size() - 1;
        }
        return new Pair<Integer, Integer>(firstProjCol, lastProjCol);
    }
}

