/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ColumnChainInfo;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ColumnInfo;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.SortKeyInfo;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.JoinPackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSortedDistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POReduceBySpark;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;

@InterfaceAudience.Private
public class SecondaryKeyOptimizerUtil {
    private static Log log = LogFactory.getLog((String)SecondaryKeyOptimizerUtil.class.getName());

    private static SortKeyInfo getSortKeyInfo(POLocalRearrange rearrange) throws ExecException {
        SortKeyInfo result = new SortKeyInfo();
        List<PhysicalPlan> plans = rearrange.getPlans();
        block0: for (int i = 0; i < plans.size(); ++i) {
            PhysicalPlan plan = plans.get(i);
            ColumnChainInfo columnChainInfo = new ColumnChainInfo();
            if (plan.getRoots() == null) {
                log.debug((Object)"POLocalRearrange plan is null");
                return null;
            }
            if (plan.getRoots().size() != 1) continue;
            ArrayList<Integer> columns = new ArrayList<Integer>();
            columns.add(rearrange.getIndex() & 0x7F);
            columnChainInfo.insert(columns, (byte)110);
            PhysicalOperator node = (PhysicalOperator)plan.getRoots().get(0);
            while (node != null) {
                if (!(node instanceof POProject)) continue block0;
                POProject project = (POProject)node;
                if (project.isProjectToEnd()) {
                    columnChainInfo.insert(project.getStartCol(), project.getResultType());
                } else {
                    columnChainInfo.insert(project.getColumns(), project.getResultType());
                }
                if (plan.getSuccessors(node) == null) {
                    node = null;
                    continue;
                }
                if (plan.getSuccessors(node).size() != 1) {
                    log.debug((Object)(node + " have more than 1 successor"));
                    node = null;
                    continue;
                }
                node = plan.getSuccessors(node).get(0);
            }
            result.insertColumnChainInfo(i, columnChainInfo, true);
        }
        return result;
    }

    public SecondaryKeyOptimizerInfo applySecondaryKeySort(PhysicalPlan mapPlan, PhysicalPlan reducePlan) throws VisitorException {
        PhysicalOperator mapLeaf;
        ArrayList<POToChange> distinctsToChange;
        ArrayList<POToChange> sortsToRemove;
        SortKeyInfo secondarySortKeyInfo;
        ArrayList<SortKeyInfo> sortKeyInfos;
        SecondaryKeyOptimizerInfo secKeyOptimizerInfo;
        block42: {
            log.trace((Object)"Entering SecondaryKeyOptimizerUtil.addSecondaryKeySort");
            secKeyOptimizerInfo = new SecondaryKeyOptimizerInfo();
            sortKeyInfos = new ArrayList<SortKeyInfo>();
            secondarySortKeyInfo = null;
            sortsToRemove = null;
            distinctsToChange = null;
            List mapLeaves = mapPlan.getLeaves();
            if (mapLeaves == null || mapLeaves.size() != 1) {
                log.debug((Object)"Expected map to have single leaf! Skip secondary key optimizing");
                return null;
            }
            mapLeaf = (PhysicalOperator)mapLeaves.get(0);
            try {
                if (mapLeaf instanceof POLocalRearrange) {
                    SortKeyInfo sortKeyInfo = SecondaryKeyOptimizerUtil.getSortKeyInfo((POLocalRearrange)mapLeaf);
                    if (sortKeyInfo == null) {
                        log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                        return null;
                    }
                    sortKeyInfos.add(sortKeyInfo);
                    break block42;
                }
                if (mapLeaf instanceof POUnion) {
                    List<PhysicalOperator> preds = mapPlan.getPredecessors(mapLeaf);
                    for (PhysicalOperator pred : preds) {
                        if (!(pred instanceof POLocalRearrange)) continue;
                        SortKeyInfo sortKeyInfo = SecondaryKeyOptimizerUtil.getSortKeyInfo((POLocalRearrange)pred);
                        if (sortKeyInfo == null) {
                            log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                            return null;
                        }
                        sortKeyInfos.add(sortKeyInfo);
                    }
                    break block42;
                }
                log.debug((Object)"Cannot find POLocalRearrange or POUnion in map leaf, skip secondary key optimizing");
                return null;
            }
            catch (ExecException e) {
                log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                return null;
            }
        }
        if (reducePlan.isEmpty()) {
            log.debug((Object)"Reduce plan is empty, skip secondary key optimizing");
            return null;
        }
        List reduceRoots = reducePlan.getRoots();
        if (reduceRoots.size() != 1) {
            log.debug((Object)"Expected reduce to have single root, skip secondary key optimizing");
            return null;
        }
        PhysicalOperator root = (PhysicalOperator)reduceRoots.get(0);
        PhysicalOperator currentNode = this.getCurrentNode(root, reducePlan);
        POForEach foreach = null;
        while (currentNode != null) {
            if (currentNode instanceof POPackage && !(((POPackage)currentNode).getPkgr() instanceof JoinPackager) || currentNode instanceof POFilter || currentNode instanceof POLimit) {
                List<PhysicalOperator> succs = reducePlan.getSuccessors(currentNode);
                if (succs == null) {
                    return null;
                }
                if (succs.size() != 1) {
                    log.debug((Object)("See multiple output for " + currentNode + " in reduce plan, skip secondary key optimizing"));
                    return null;
                }
                currentNode = (PhysicalOperator)succs.get(0);
                continue;
            }
            if (currentNode instanceof POForEach) {
                foreach = (POForEach)currentNode;
                break;
            }
            return null;
        }
        if (foreach == null) {
            return null;
        }
        sortsToRemove = new ArrayList<POToChange>();
        distinctsToChange = new ArrayList<POToChange>();
        for (PhysicalPlan innerPlan : foreach.getInputPlans()) {
            SecondaryKeyDiscover innerPlanDiscover = new SecondaryKeyDiscover(innerPlan, sortKeyInfos, secondarySortKeyInfo);
            try {
                innerPlanDiscover.process();
            }
            catch (FrontendException e) {
                int errorCode = 2213;
                throw new VisitorException("Error visiting inner plan for ForEach", errorCode, e);
            }
            secondarySortKeyInfo = innerPlanDiscover.getSecondarySortKeyInfo();
            if (innerPlanDiscover.getSortsToRemove() != null) {
                for (POSort sort : innerPlanDiscover.getSortsToRemove()) {
                    sortsToRemove.add(new POToChange(sort, innerPlan, foreach));
                }
            }
            if (innerPlanDiscover.getDistinctsToChange() == null) continue;
            for (PODistinct distinct : innerPlanDiscover.getDistinctsToChange()) {
                distinctsToChange.add(new POToChange(distinct, innerPlan, foreach));
            }
        }
        try {
            String scope;
            for (POToChange distinctToChange : distinctsToChange) {
                secKeyOptimizerInfo.incrementNumDistinctChanged();
                PODistinct oldDistinct = (PODistinct)distinctToChange.oper;
                scope = oldDistinct.getOperatorKey().scope;
                POSortedDistinct newDistinct = new POSortedDistinct(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), oldDistinct.getRequestedParallelism(), oldDistinct.getInputs());
                newDistinct.setInputs(oldDistinct.getInputs());
                newDistinct.setResultType(oldDistinct.getResultType());
                distinctToChange.plan.replace(oldDistinct, newDistinct);
                distinctToChange.forEach.getLeaves();
            }
            for (POToChange sortToRemove : sortsToRemove) {
                secKeyOptimizerInfo.incrementNumSortRemoved();
                POSort oldSort = (POSort)sortToRemove.oper;
                scope = oldSort.getOperatorKey().scope;
                List<PhysicalOperator> preds = sortToRemove.plan.getPredecessors(sortToRemove.oper);
                List<PhysicalOperator> succs = sortToRemove.plan.getSuccessors(sortToRemove.oper);
                PORelationToExprProject project = null;
                if (!(preds != null && (preds.get(0).getResultType() == 120 || oldSort.getResultType() != 120) || succs != null && succs.get(0) instanceof PORelationToExprProject)) {
                    project = new PORelationToExprProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), oldSort.getRequestedParallelism());
                    project.setInputs(oldSort.getInputs());
                    project.setResultType((byte)120);
                    project.setStar(true);
                }
                if (project == null) {
                    sortToRemove.plan.removeAndReconnect(sortToRemove.oper);
                } else {
                    sortToRemove.plan.replace(oldSort, project);
                }
                sortToRemove.forEach.getLeaves();
            }
        }
        catch (PlanException e) {
            int errorCode = 2202;
            throw new VisitorException("Error change distinct/sort to use secondary key optimizer", errorCode, e);
        }
        if (secondarySortKeyInfo != null) {
            secKeyOptimizerInfo.incrementNumUseSecondaryKey();
            secKeyOptimizerInfo.setUseSecondaryKey(true);
            secKeyOptimizerInfo.setSecondarySortOrder(secondarySortKeyInfo.getAscs());
            byte indexOfRearrangeToChange = -1;
            for (ColumnChainInfo columnChainInfo : secondarySortKeyInfo.getColumnChains()) {
                ColumnInfo currentColumn = columnChainInfo.getColumnInfos().get(0);
                byte index = currentColumn.getColumns().get(0).intValue();
                if (indexOfRearrangeToChange == -1) {
                    indexOfRearrangeToChange = index;
                    continue;
                }
                if (indexOfRearrangeToChange == index) continue;
                int errorCode = 2203;
                throw new VisitorException("Sort on columns from different inputs.", errorCode);
            }
            if (mapLeaf instanceof POLocalRearrange) {
                ((POLocalRearrange)mapLeaf).setUseSecondaryKey(true);
                SecondaryKeyOptimizerUtil.setSecondaryPlan(mapPlan, (POLocalRearrange)mapLeaf, secondarySortKeyInfo);
            } else if (mapLeaf instanceof POUnion) {
                List<PhysicalOperator> preds = mapPlan.getPredecessors(mapLeaf);
                boolean found = false;
                for (PhysicalOperator pred : preds) {
                    POLocalRearrange rearrange = (POLocalRearrange)pred;
                    rearrange.setUseSecondaryKey(true);
                    if (rearrange.getIndex() != indexOfRearrangeToChange) continue;
                    found = true;
                    SecondaryKeyOptimizerUtil.setSecondaryPlan(mapPlan, rearrange, secondarySortKeyInfo);
                }
                if (!found) {
                    int errorCode = 2214;
                    throw new VisitorException("Cannot find POLocalRearrange to set secondary plan", errorCode);
                }
            }
            if (root instanceof POGlobalRearrangeSpark) {
                POGlobalRearrangeSpark plg = (POGlobalRearrangeSpark)root;
                plg.setUseSecondaryKey(true);
                plg.setSecondarySortOrder(secondarySortKeyInfo.getAscs());
            } else if (root instanceof POPackage) {
                POPackage pack = (POPackage)root;
                pack.getPkgr().setUseSecondaryKey(true);
            } else if (root instanceof POReduceBySpark) {
                POReduceBySpark reduceBySpark = (POReduceBySpark)root;
                reduceBySpark.setUseSecondaryKey(true);
                reduceBySpark.setSecondarySortOrder(secondarySortKeyInfo.getAscs());
            }
        }
        return secKeyOptimizerInfo;
    }

    protected PhysicalOperator getCurrentNode(PhysicalOperator root, PhysicalPlan reducePlan) {
        PhysicalOperator currentNode = null;
        if (!(root instanceof POPackage)) {
            log.debug((Object)"Expected reduce root to be a POPackage, skip secondary key optimizing");
        } else {
            currentNode = root;
        }
        return currentNode;
    }

    private static void setSecondaryPlan(PhysicalPlan plan, POLocalRearrange rearrange, SortKeyInfo secondarySortKeyInfo) throws VisitorException {
        try {
            String scope = rearrange.getOperatorKey().scope;
            ArrayList<PhysicalPlan> secondaryPlanList = new ArrayList<PhysicalPlan>();
            for (ColumnChainInfo columnChainInfo : secondarySortKeyInfo.getColumnChains()) {
                PhysicalPlan secondaryPlan = new PhysicalPlan();
                for (int i = 1; i < columnChainInfo.size(); ++i) {
                    ColumnInfo columnInfo = columnChainInfo.getColumnInfo(i);
                    POProject project = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), rearrange.getRequestedParallelism());
                    if (columnInfo.isRangeProject()) {
                        project.setProjectToEnd(columnInfo.getStartCol());
                    } else {
                        project.setColumns((ArrayList)columnInfo.getColumns());
                    }
                    project.setResultType(columnInfo.getResultType());
                    secondaryPlan.addAsLeaf(project);
                }
                if (secondaryPlan.isEmpty()) {
                    POProject project = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), rearrange.getRequestedParallelism());
                    project.setStar(true);
                    secondaryPlan.addAsLeaf(project);
                }
                secondaryPlanList.add(secondaryPlan);
            }
            rearrange.setSecondaryPlans(secondaryPlanList);
        }
        catch (PlanException e) {
            int errorCode = 2204;
            throw new VisitorException("Error setting secondary key plan", errorCode, e);
        }
    }

    private static boolean collectColumnChain(PhysicalPlan plan, ColumnChainInfo columnChainInfo) throws PlanException {
        if (plan.getRoots().size() != 1) {
            return true;
        }
        PhysicalOperator currentNode = (PhysicalOperator)plan.getRoots().get(0);
        while (currentNode != null) {
            if (!(currentNode instanceof POProject)) {
                return true;
            }
            POProject project = (POProject)currentNode;
            columnChainInfo.insertInReduce(project);
            List<PhysicalOperator> succs = plan.getSuccessors(currentNode);
            if (succs == null) break;
            if (succs.size() != 1) {
                int errorCode = 2208;
                throw new PlanException("Exception visiting foreach inner plan", errorCode);
            }
            currentNode = succs.get(0);
        }
        return false;
    }

    private static class SecondaryKeyDiscover {
        PhysicalPlan mPlan;
        List<POSort> sortsToRemove = new ArrayList<POSort>();
        List<PODistinct> distinctsToChange = new ArrayList<PODistinct>();
        List<SortKeyInfo> sortKeyInfos;
        SortKeyInfo secondarySortKeyInfo;
        ColumnChainInfo columnChainInfo = null;

        SecondaryKeyDiscover(PhysicalPlan plan, List<SortKeyInfo> sortKeyInfos, SortKeyInfo secondarySortKeyInfo) {
            this.mPlan = plan;
            this.sortKeyInfos = sortKeyInfos;
            this.secondarySortKeyInfo = secondarySortKeyInfo;
        }

        public void process() throws FrontendException {
            List roots = this.mPlan.getRoots();
            for (PhysicalOperator root : roots) {
                this.columnChainInfo = new ColumnChainInfo();
                this.processRoot(root);
            }
        }

        public void processRoot(PhysicalOperator root) throws FrontendException {
            PhysicalOperator currentNode = root;
            while (currentNode != null) {
                boolean sawInvalidPhysicalOper = false;
                if (currentNode instanceof PODistinct) {
                    sawInvalidPhysicalOper = this.processDistinct((PODistinct)currentNode);
                } else if (currentNode instanceof POSort) {
                    sawInvalidPhysicalOper = this.processSort((POSort)currentNode);
                } else if (currentNode instanceof POProject) {
                    sawInvalidPhysicalOper = this.processProject((POProject)currentNode);
                } else if (currentNode instanceof POUserFunc || currentNode instanceof POUnion || currentNode instanceof POForEach) break;
                if (sawInvalidPhysicalOper) break;
                List<PhysicalOperator> succs = this.mPlan.getSuccessors(currentNode);
                if (succs == null) {
                    currentNode = null;
                    continue;
                }
                if (succs.size() > 1) {
                    int errorCode = 2215;
                    throw new FrontendException("See more than 1 successors in the nested plan for " + currentNode, errorCode);
                }
                currentNode = succs.get(0);
            }
        }

        public boolean processDistinct(PODistinct distinct) throws FrontendException {
            SortKeyInfo keyInfos = new SortKeyInfo();
            try {
                keyInfos.insertColumnChainInfo(0, (ColumnChainInfo)this.columnChainInfo.clone(), true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            for (SortKeyInfo sortKeyInfo : this.sortKeyInfos) {
                if (!sortKeyInfo.moreSpecificThan(keyInfos)) continue;
                this.distinctsToChange.add(distinct);
                return false;
            }
            if (this.secondarySortKeyInfo != null && this.secondarySortKeyInfo.moreSpecificThan(keyInfos)) {
                this.distinctsToChange.add(distinct);
                return false;
            }
            if (this.secondarySortKeyInfo == null) {
                this.distinctsToChange.add(distinct);
                this.secondarySortKeyInfo = keyInfos;
            }
            return false;
        }

        public boolean processProject(POProject project) throws FrontendException {
            this.columnChainInfo.insertInReduce(project);
            return false;
        }

        public boolean processSort(POSort sort) throws FrontendException {
            if (sort.isLimited()) {
                return true;
            }
            SortKeyInfo keyInfo = new SortKeyInfo();
            for (int i = 0; i < sort.getSortPlans().size(); ++i) {
                PhysicalPlan sortPlan = sort.getSortPlans().get(i);
                ColumnChainInfo sortChainInfo = null;
                try {
                    sortChainInfo = (ColumnChainInfo)this.columnChainInfo.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                boolean r = false;
                try {
                    r = SecondaryKeyOptimizerUtil.collectColumnChain(sortPlan, sortChainInfo);
                }
                catch (PlanException e) {
                    int errorCode = 2206;
                    throw new FrontendException("Error visiting POSort inner plan", errorCode, e);
                }
                if (r) {
                    return true;
                }
                keyInfo.insertColumnChainInfo(i, sortChainInfo, sort.getMAscCols().get(i));
            }
            for (SortKeyInfo sortKeyInfo : this.sortKeyInfos) {
                if (!sortKeyInfo.moreSpecificThan(keyInfo)) continue;
                this.sortsToRemove.add(sort);
                return false;
            }
            if (this.secondarySortKeyInfo != null && this.secondarySortKeyInfo.moreSpecificThan(keyInfo)) {
                this.sortsToRemove.add(sort);
                return false;
            }
            if (this.secondarySortKeyInfo == null) {
                this.sortsToRemove.add(sort);
                this.secondarySortKeyInfo = keyInfo;
            }
            return false;
        }

        public List<POSort> getSortsToRemove() {
            return this.sortsToRemove;
        }

        public List<PODistinct> getDistinctsToChange() {
            return this.distinctsToChange;
        }

        public SortKeyInfo getSecondarySortKeyInfo() {
            return this.secondarySortKeyInfo;
        }
    }

    public static class SecondaryKeyOptimizerInfo {
        private int numSortRemoved = 0;
        private int numDistinctChanged = 0;
        private int numUseSecondaryKey = 0;
        private boolean useSecondaryKey = false;
        private boolean[] secondarySortOrder;

        public int getNumSortRemoved() {
            return this.numSortRemoved;
        }

        public void incrementNumSortRemoved() {
            ++this.numSortRemoved;
        }

        public int getNumDistinctChanged() {
            return this.numDistinctChanged;
        }

        public void incrementNumDistinctChanged() {
            ++this.numDistinctChanged;
        }

        public int getNumUseSecondaryKey() {
            return this.numUseSecondaryKey;
        }

        public void incrementNumUseSecondaryKey() {
            ++this.numUseSecondaryKey;
        }

        public boolean isUseSecondaryKey() {
            return this.useSecondaryKey;
        }

        public void setUseSecondaryKey(boolean useSecondaryKey) {
            this.useSecondaryKey = useSecondaryKey;
        }

        public boolean[] getSecondarySortOrder() {
            return this.secondarySortOrder;
        }

        public void setSecondarySortOrder(boolean[] secondarySortOrder) {
            this.secondarySortOrder = secondarySortOrder;
        }
    }

    private static class POToChange {
        PhysicalOperator oper;
        PhysicalPlan plan;
        POForEach forEach;

        POToChange(PhysicalOperator oper, PhysicalPlan plan, POForEach forEach) {
            this.oper = oper;
            this.plan = plan;
            this.forEach = forEach;
        }
    }
}

