/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface LoadBalancer
extends Configurable,
Stoppable,
ConfigurationObserver {
    @Deprecated
    public static final String TABLES_ON_MASTER = "hbase.balancer.tablesOnMaster";
    @Deprecated
    public static final String SYSTEM_TABLES_ON_MASTER = "hbase.balancer.tablesOnMaster.systemTablesOnly";
    public static final ServerName BOGUS_SERVER_NAME = ServerName.valueOf((String)"localhost,1,1");

    public void setClusterMetrics(ClusterMetrics var1);

    public void setMasterServices(MasterServices var1);

    public List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> var1) throws IOException;

    public List<RegionPlan> balanceTable(TableName var1, Map<ServerName, List<RegionInfo>> var2);

    @NonNull
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> var1, List<ServerName> var2) throws HBaseIOException;

    @NonNull
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> var1, List<ServerName> var2) throws HBaseIOException;

    public ServerName randomAssignment(RegionInfo var1, List<ServerName> var2) throws HBaseIOException;

    public void initialize() throws HBaseIOException;

    public void regionOnline(RegionInfo var1, ServerName var2);

    public void regionOffline(RegionInfo var1);

    public void onConfigurationChange(Configuration var1);

    public void postMasterStartupInitialize();

    public void updateBalancerStatus(boolean var1);

    @Deprecated
    public static boolean isTablesOnMaster(Configuration conf) {
        return conf.getBoolean(TABLES_ON_MASTER, false);
    }

    @Deprecated
    public static boolean isSystemTablesOnlyOnMaster(Configuration conf) {
        return conf.getBoolean(SYSTEM_TABLES_ON_MASTER, false);
    }

    @Deprecated
    public static boolean isMasterCanHostUserRegions(Configuration conf) {
        return LoadBalancer.isTablesOnMaster(conf) && !LoadBalancer.isSystemTablesOnlyOnMaster(conf);
    }
}

