/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.accumulo.core.cli.Help;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.math.LongRange;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.XMLLayout;

public class SendLogToChainsaw
extends XMLLayout {
    private static Pattern logPattern = Pattern.compile("^(\\d\\d)\\s(\\d\\d):(\\d\\d):(\\d\\d),(\\d\\d\\d)\\s\\[(.*)\\]\\s(TRACE|DEBUG|INFO|WARN|FATAL|ERROR)\\s*?:(.*)$", 1);
    private File[] logFiles = null;
    private SocketFactory factory = SocketFactory.getDefault();
    private WildcardFileFilter fileFilter = null;
    private Socket socket = null;
    private Pattern lineFilter = null;
    private LongRange dateFilter = null;
    private LevelRangeFilter levelFilter = null;

    public SendLogToChainsaw(String directory, String fileNameFilter, String host, int port, Date start, Date end, String regex, String level) throws Exception {
        this.fileFilter = null != fileNameFilter ? new WildcardFileFilter(fileNameFilter) : new WildcardFileFilter("*");
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory or is not readable.");
        }
        this.logFiles = dir.listFiles((FilenameFilter)this.fileFilter);
        if (this.logFiles == null || this.logFiles.length == 0) {
            throw new IllegalArgumentException("No files match the supplied filter.");
        }
        this.socket = this.factory.createSocket(host, port);
        this.lineFilter = Pattern.compile(regex);
        if (null != start) {
            if (end == null) {
                end = new Date(System.currentTimeMillis());
            }
            this.dateFilter = new LongRange(start.getTime(), end.getTime());
        }
        if (null != level) {
            Level base = Level.toLevel((String)level.toUpperCase());
            this.levelFilter = new LevelRangeFilter();
            this.levelFilter.setAcceptOnMatch(true);
            this.levelFilter.setLevelMin(base);
            this.levelFilter.setLevelMax(Level.FATAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLogFiles() throws IOException {
        String line = null;
        String out = null;
        try {
            for (File log : this.logFiles) {
                FileInputStream fis;
                String threadName = log.getName().substring(0, log.getName().indexOf("."));
                try {
                    fis = new FileInputStream(log);
                }
                catch (FileNotFoundException e) {
                    System.out.println("Unable to find file: " + log.getAbsolutePath());
                    throw e;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));){
                    line = reader.readLine();
                    while (null != line) {
                        out = this.convertLine(line, threadName);
                        if (null != out) {
                            if (this.socket != null && this.socket.isConnected()) {
                                this.socket.getOutputStream().write(out.getBytes(StandardCharsets.UTF_8));
                            } else {
                                System.err.println("Unable to send data to transport");
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("Error processing line: " + line + ". Output was " + out);
                    throw e;
                }
            }
        }
        finally {
            if (this.socket != null && this.socket.isConnected()) {
                this.socket.close();
            }
        }
    }

    private String convertLine(String line, String threadName) throws UnsupportedEncodingException {
        String result = null;
        Matcher m = logPattern.matcher(line);
        if (m.matches()) {
            Matcher match;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(System.currentTimeMillis()));
            Integer date = Integer.parseInt(m.group(1));
            Integer hour = Integer.parseInt(m.group(2));
            Integer min = Integer.parseInt(m.group(3));
            Integer sec = Integer.parseInt(m.group(4));
            Integer ms = Integer.parseInt(m.group(5));
            String clazz = m.group(6);
            String level = m.group(7);
            String message = m.group(8);
            if (null != this.lineFilter && !(match = this.lineFilter.matcher(message)).matches()) {
                return null;
            }
            message = URLEncoder.encode(message, StandardCharsets.UTF_8.name());
            cal.set(5, date);
            cal.set(11, hour);
            cal.set(12, min);
            cal.set(13, sec);
            cal.set(14, ms);
            if (date > cal.get(5)) {
                cal.add(2, -1);
            }
            long ts = cal.getTimeInMillis();
            if (null != this.dateFilter && !this.dateFilter.containsLong(ts)) {
                return null;
            }
            Logger c = Logger.getLogger((String)clazz);
            Level l = Level.toLevel((String)level);
            LoggingEvent event = new LoggingEvent(clazz, (Category)c, ts, l, (Object)message, threadName, (ThrowableInformation)null, (String)null, (LocationInfo)null, (Map)null);
            if (null != this.levelFilter && this.levelFilter.decide(event) == -1) {
                return null;
            }
            result = this.format(event);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(SendLogToChainsaw.class.getName(), args, new Object[0]);
        SendLogToChainsaw c = new SendLogToChainsaw(opts.dir, opts.filter, opts.hostname, opts.portnum, opts.startDate, opts.endDate, opts.regex, opts.level);
        c.processLogFiles();
    }

    private static class Opts
    extends Help {
        @Parameter(names={"-d", "--logDirectory"}, description="ACCUMULO log directory path", required=true)
        String dir;
        @Parameter(names={"-f", "--fileFilter"}, description="filter to apply to names of logs")
        String filter;
        @Parameter(names={"-h", "--host"}, description="host where chainsaw is running", required=true)
        String hostname;
        @Parameter(names={"-p", "--port"}, description="port where XMLSocketReceiver is listening", required=true)
        int portnum;
        @Parameter(names={"-s", "--start"}, description="start date filter (yyyyMMddHHmmss)", required=true, converter=DateConverter.class)
        Date startDate;
        @Parameter(names={"-e", "--end"}, description="end date filter (yyyyMMddHHmmss)", required=true, converter=DateConverter.class)
        Date endDate;
        @Parameter(names={"-l", "--level"}, description="filter log level")
        String level;
        @Parameter(names={"-m", "--messageFilter"}, description="regex filter for log messages")
        String regex;

        private Opts() {
        }
    }

    private static class DateConverter
    implements IStringConverter<Date> {
        private DateConverter() {
        }

        public Date convert(String value) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                return formatter.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

