/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;

public class MetricsSystemHelper {
    private static String processName = "Unknown";

    public static void configure(String serviceName) {
        processName = serviceName;
        String serviceInstance = System.getProperty("accumulo.metrics.service.instance", "");
        if (StringUtils.isNotBlank((String)serviceInstance)) {
            processName = processName + serviceInstance;
        }
    }

    public static String getProcessName() {
        return processName;
    }

    public static MetricsSystem getInstance() {
        if (MetricsSystemHolder.metricsSystem.getSource(JvmMetricsInfo.JvmMetrics.name()) == null) {
            JvmMetrics.create((String)MetricsSystemHelper.getProcessName(), (String)"", (MetricsSystem)MetricsSystemHolder.metricsSystem);
        }
        return MetricsSystemHolder.metricsSystem;
    }

    private static class MetricsSystemHolder {
        private static final MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)"Accumulo");

        private MetricsSystemHolder() {
        }
    }
}

