/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.Text;

public abstract class RowFilter
extends WrappingIterator {
    private RowIterator decisionIterator;
    private Collection<ByteSequence> columnFamilies;
    Text currentRow;
    private boolean inclusive;
    private Range range;
    private boolean hasTop;

    private void skipRows() throws IOException {
        SortedKeyValueIterator<Key, Value> source = this.getSource();
        while (source.hasTop()) {
            Text row = source.getTopKey().getRow();
            if (this.currentRow != null && this.currentRow.equals((Object)row)) break;
            Range rowRange = new Range(row);
            this.decisionIterator.setRow(rowRange);
            this.decisionIterator.seek(rowRange, this.columnFamilies, this.inclusive);
            if (this.acceptRow(this.decisionIterator)) {
                this.currentRow = row;
                break;
            }
            this.currentRow = null;
            for (int count = 0; source.hasTop() && count < 10 && source.getTopKey().getRow().equals((Object)row); ++count) {
                source.next();
            }
            if (!source.hasTop() || !source.getTopKey().getRow().equals((Object)row)) continue;
            Range nextRow = new Range(row, false, null, false);
            if ((nextRow = this.range.clip(nextRow, true)) == null) {
                this.hasTop = false;
                continue;
            }
            source.seek(nextRow, this.columnFamilies, this.inclusive);
        }
    }

    public abstract boolean acceptRow(SortedKeyValueIterator<Key, Value> var1) throws IOException;

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.decisionIterator = new RowIterator(source.deepCopy(env));
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        RowFilter newInstance;
        try {
            newInstance = (RowFilter)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.decisionIterator = new RowIterator(this.getSource().deepCopy(env));
        return newInstance;
    }

    @Override
    public boolean hasTop() {
        return this.hasTop && super.hasTop();
    }

    @Override
    public void next() throws IOException {
        super.next();
        this.skipRows();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        this.columnFamilies = columnFamilies;
        this.inclusive = inclusive;
        this.range = range;
        this.currentRow = null;
        this.hasTop = true;
        this.skipRows();
    }

    private static class RowIterator
    extends WrappingIterator {
        private Range rowRange;
        private boolean hasTop;

        RowIterator(SortedKeyValueIterator<Key, Value> source) {
            super.setSource(source);
        }

        void setRow(Range row) {
            this.rowRange = row;
        }

        @Override
        public boolean hasTop() {
            return this.hasTop && super.hasTop();
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if ((range = this.rowRange.clip(range, true)) == null) {
                this.hasTop = false;
            } else {
                this.hasTop = true;
                super.seek(range, columnFamilies, inclusive);
            }
        }
    }
}

