/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

class OfflineIterator
implements Iterator<Map.Entry<Key, Value>> {
    private SortedKeyValueIterator<Key, Value> iter;
    private Range range;
    private KeyExtent currentExtent;
    private Connector conn;
    private String tableId;
    private Authorizations authorizations;
    private Instance instance;
    private ScannerOptions options;
    private ArrayList<SortedKeyValueIterator<Key, Value>> readers;
    private AccumuloConfiguration config;

    public OfflineIterator(ScannerOptions options, Instance instance, Credentials credentials, Authorizations authorizations, Text table, Range range) {
        this.options = new ScannerOptions(options);
        this.instance = instance;
        this.range = range;
        if (this.options.fetchedColumns.size() > 0) {
            this.range = range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last());
        }
        this.tableId = table.toString();
        this.authorizations = authorizations;
        this.readers = new ArrayList();
        try {
            this.conn = instance.getConnector(credentials.getPrincipal(), credentials.getToken());
            this.config = new ConfigurationCopy(this.conn.instanceOperations().getSiteConfiguration());
            this.nextTablet();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasTop();
    }

    @Override
    public Map.Entry<Key, Value> next() {
        try {
            byte[] v = this.iter.getTopValue().get();
            KeyValue ret = new KeyValue(new Key(this.iter.getTopKey()), Arrays.copyOf(v, v.length));
            this.iter.next();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void nextTablet() throws TableNotFoundException, AccumuloException, IOException {
        Range nextRange = null;
        if (this.currentExtent == null) {
            Text startRow = this.range.getStartKey() != null ? this.range.getStartKey().getRow() : new Text();
            nextRange = new Range(new KeyExtent(this.tableId, startRow, null).getMetadataEntry(), true, null, false);
        } else {
            if (this.currentExtent.getEndRow() == null) {
                this.iter = null;
                return;
            }
            if (this.range.afterEndKey(new Key(this.currentExtent.getEndRow()).followingKey(PartialKey.ROW))) {
                this.iter = null;
                return;
            }
            nextRange = new Range(this.currentExtent.getMetadataEntry(), false, null, false);
        }
        ArrayList<String> relFiles = new ArrayList<String>();
        Pair<KeyExtent, String> eloc = this.getTabletFiles(nextRange, relFiles);
        while (eloc.getSecond() != null) {
            if (Tables.getTableState(this.instance, this.tableId) != TableState.OFFLINE) {
                Tables.clearCache(this.instance);
                if (Tables.getTableState(this.instance, this.tableId) != TableState.OFFLINE) {
                    throw new AccumuloException("Table is online " + this.tableId + " cannot scan tablet in offline mode " + eloc.getFirst());
                }
            }
            UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
            eloc = this.getTabletFiles(nextRange, relFiles);
        }
        KeyExtent extent = eloc.getFirst();
        if (!extent.getTableId().equals(this.tableId)) {
            throw new AccumuloException(" did not find tablets for table " + this.tableId + " " + extent);
        }
        if (this.currentExtent != null && !extent.isPreviousExtent(this.currentExtent)) {
            throw new AccumuloException(" " + this.currentExtent + " is not previous extent " + extent);
        }
        String tablesDir = this.config.get(Property.INSTANCE_DFS_DIR) + "/tables";
        ArrayList<String> absFiles = new ArrayList<String>();
        for (String relPath : relFiles) {
            if (relPath.contains(":")) {
                absFiles.add(relPath);
                continue;
            }
            if (relPath.startsWith("..")) {
                absFiles.add(tablesDir + relPath.substring(2));
                continue;
            }
            absFiles.add(tablesDir + "/" + this.tableId + relPath);
        }
        this.iter = this.createIterator(extent, absFiles);
        this.iter.seek(this.range, (Collection<ByteSequence>)LocalityGroupUtil.families(this.options.fetchedColumns), this.options.fetchedColumns.size() != 0);
        this.currentExtent = extent;
    }

    private Pair<KeyExtent, String> getTabletFiles(Range nextRange, List<String> relFiles) throws TableNotFoundException {
        Scanner scanner = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setBatchSize(100);
        scanner.setRange(nextRange);
        RowIterator rowIter = new RowIterator(scanner);
        Object row = rowIter.next();
        KeyExtent extent = null;
        String location = null;
        while (row.hasNext()) {
            Map.Entry entry = (Map.Entry)row.next();
            Key key = (Key)entry.getKey();
            if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                relFiles.add(key.getColumnQualifier().toString());
            }
            if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) || key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                location = ((Value)entry.getValue()).toString();
            }
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
            extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
        }
        return new Pair<Object, Object>(extent, location);
    }

    private SortedKeyValueIterator<Key, Value> createIterator(KeyExtent extent, List<String> absFiles) throws TableNotFoundException, AccumuloException, IOException {
        AccumuloConfiguration acuTableConf = AccumuloConfiguration.getTableConfiguration(this.conn, this.tableId);
        Configuration conf = CachedConfiguration.getInstance();
        for (SortedKeyValueIterator<Key, Value> reader : this.readers) {
            ((FileSKVIterator)reader).close();
        }
        this.readers.clear();
        SamplerConfiguration scannerSamplerConfig = this.options.getSamplerConfiguration();
        SamplerConfigurationImpl scannerSamplerConfigImpl = scannerSamplerConfig == null ? null : new SamplerConfigurationImpl(scannerSamplerConfig);
        SamplerConfigurationImpl samplerConfImpl = SamplerConfigurationImpl.newSamplerConfig(acuTableConf);
        if (scannerSamplerConfigImpl != null && (samplerConfImpl != null && !scannerSamplerConfigImpl.equals(samplerConfImpl) || samplerConfImpl == null)) {
            throw new SampleNotPresentException();
        }
        for (String file : absFiles) {
            FileSystem fs = VolumeConfiguration.getVolume(file, conf, this.config).getFileSystem();
            FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(file, fs, conf).withTableConfiguration(acuTableConf).build();
            if (scannerSamplerConfigImpl != null && (reader = reader.getSample(scannerSamplerConfigImpl)) == null) {
                throw new SampleNotPresentException();
            }
            this.readers.add(reader);
        }
        MultiIterator multiIter = new MultiIterator(this.readers, extent);
        OfflineIteratorEnvironment iterEnv = new OfflineIteratorEnvironment(this.authorizations, acuTableConf, false, samplerConfImpl == null ? null : samplerConfImpl.toSamplerConfiguration());
        ColumnVisibility cv = new ColumnVisibility(acuTableConf.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
        byte[] defaultSecurityLabel = cv.getExpression();
        SortedKeyValueIterator<Key, Value> visFilter = IteratorUtil.setupSystemScanIterators(multiIter, new HashSet<Column>(this.options.fetchedColumns), this.authorizations, defaultSecurityLabel);
        return iterEnv.getTopLevelIterator(IteratorUtil.loadIterators(IteratorUtil.IteratorScope.scan, visFilter, extent, acuTableConf, this.options.serverSideIteratorList, this.options.serverSideIteratorOptions, iterEnv, false));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class OfflineIteratorEnvironment
    implements IteratorEnvironment {
        private final Authorizations authorizations;
        private AccumuloConfiguration conf;
        private boolean useSample;
        private SamplerConfiguration sampleConf;
        private ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();

        public OfflineIteratorEnvironment(Authorizations auths, AccumuloConfiguration acuTableConf, boolean useSample, SamplerConfiguration samplerConf) {
            this.authorizations = auths;
            this.conf = acuTableConf;
            this.useSample = useSample;
            this.sampleConf = samplerConf;
        }

        @Override
        public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public AccumuloConfiguration getConfig() {
            return this.conf;
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
            this.topLevelIterators.add(iter);
        }

        @Override
        public Authorizations getAuthorizations() {
            return this.authorizations;
        }

        SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
            if (this.topLevelIterators.isEmpty()) {
                return iter;
            }
            ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
            allIters.add(iter);
            return new MultiIterator(allIters, false);
        }

        @Override
        public boolean isSamplingEnabled() {
            return this.useSample;
        }

        @Override
        public SamplerConfiguration getSamplerConfiguration() {
            return this.sampleConf;
        }

        @Override
        public IteratorEnvironment cloneWithSamplingEnabled() {
            if (this.sampleConf == null) {
                throw new SampleNotPresentException();
            }
            return new OfflineIteratorEnvironment(this.authorizations, this.conf, true, this.sampleConf);
        }
    }
}

