/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;

public class NamespaceNotFoundException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String namespace;

    public NamespaceNotFoundException(String namespaceId, String namespaceName, String description) {
        super("Namespace" + (namespaceName != null && !namespaceName.isEmpty() ? " " + namespaceName : "") + (namespaceId != null && !namespaceId.isEmpty() ? " (Id=" + namespaceId + ")" : "") + " does not exist" + (description != null && !description.isEmpty() ? " (" + description + ")" : ""));
        this.namespace = namespaceName;
    }

    public NamespaceNotFoundException(String namespaceId, String namespaceName, String description, Throwable cause) {
        this(namespaceId, namespaceName, description);
        super.initCause(cause);
    }

    public NamespaceNotFoundException(ThriftTableOperationException e) {
        this(e.getTableId(), e.getTableName(), e.getDescription(), (Throwable)((Object)e));
    }

    public String getNamespaceName() {
        return this.namespace;
    }
}

