/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.util.LZFFileInputStream;
import com.ning.compress.lzf.util.LZFFileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZF {
    public static final String SUFFIX = ".lzf";

    protected void process(String[] args) throws IOException {
        if (args.length == 2) {
            boolean toSystemOutput;
            String oper = args[0];
            boolean compress = "-c".equals(oper);
            boolean bl = toSystemOutput = !compress && "-o".equals(oper);
            if (compress || toSystemOutput || "-d".equals(oper)) {
                String filename = args[1];
                File src = new File(filename);
                if (!src.exists()) {
                    System.err.println("File '" + filename + "' does not exist.");
                    System.exit(1);
                }
                if (!compress && !filename.endsWith(SUFFIX)) {
                    System.err.println("File '" + filename + "' does end with expected suffix ('" + SUFFIX + "', won't decompress.");
                    System.exit(1);
                }
                if (compress) {
                    int bytesRead;
                    int inputLength = 0;
                    File resultFile = new File(filename + SUFFIX);
                    FileInputStream in = new FileInputStream(src);
                    LZFFileOutputStream out = new LZFFileOutputStream(resultFile);
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                        inputLength += bytesRead;
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    System.out.printf("Compressed '%s' into '%s' (%d->%d bytes)\n", src.getPath(), resultFile.getPath(), inputLength, resultFile.length());
                } else {
                    OutputStream out;
                    LZFFileInputStream in = new LZFFileInputStream(src);
                    File resultFile = null;
                    if (toSystemOutput) {
                        out = System.out;
                    } else {
                        resultFile = new File(filename.substring(0, filename.length() - SUFFIX.length()));
                        out = new FileOutputStream(resultFile);
                    }
                    int uncompLen = in.readAndWrite(out);
                    in.close();
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    if (resultFile != null) {
                        System.out.printf("Uncompressed '%s' into '%s' (%d->%d bytes)\n", src.getPath(), resultFile.getPath(), src.length(), uncompLen);
                    }
                }
                return;
            }
        }
        System.err.println("Usage: java " + this.getClass().getName() + " -c/-d/-o source-file");
        System.err.println(" -d parameter: decompress to file");
        System.err.println(" -c parameter: compress to file");
        System.err.println(" -o parameter: decompress to stdout");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        new LZF().process(args);
    }
}

