/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.backend.hadoop.BigDecimalWritable;
import org.apache.pig.impl.io.NullableBigDecimalWritable;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigBigDecimalRawComparator
extends WritableComparator
implements Configurable {
    private static final Log mLog = LogFactory.getLog(PigBigDecimalRawComparator.class);
    private boolean[] mAsc;
    private final BigDecimalWritable.Comparator mWrappedComp = new BigDecimalWritable.Comparator();

    public PigBigDecimalRawComparator() {
        super(NullableBigDecimalWritable.class);
    }

    public Configuration getConf() {
        return null;
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            mLog.error((Object)("Unable to deserialize pig.sortOrder " + ioe.getMessage()));
            throw new RuntimeException(ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        rc = b1[s1] == 0 && b2[s2] == 0 ? this.mWrappedComp.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2) : (b1[s1] != 0 && b2[s2] != 0 ? b1[s1 + 1] - b2[s2 + 1] : (b1[s1] != 0 ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableBigDecimalWritable ndw1 = (NullableBigDecimalWritable)o1;
        NullableBigDecimalWritable ndw2 = (NullableBigDecimalWritable)o2;
        int rc = 0;
        rc = !ndw1.isNull() && !ndw2.isNull() ? ((BigDecimal)ndw1.getValueAsPigType()).compareTo((BigDecimal)ndw2.getValueAsPigType()) : (ndw1.isNull() && ndw2.isNull() ? ndw1.getIndex() - ndw2.getIndex() : (ndw1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

