/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Scanner;

public class ScanSession
extends Session {
    public final Stat nbTimes = new Stat();
    public final KeyExtent extent;
    public final Set<Column> columnSet;
    public final List<IterInfo> ssiList;
    public final Map<String, Map<String, String>> ssio;
    public final Authorizations auths;
    public final AtomicBoolean interruptFlag = new AtomicBoolean();
    public long entriesReturned = 0L;
    public long batchCount = 0L;
    public volatile ScanTask<ScanBatch> nextBatchTask;
    public Scanner scanner;
    public final long readaheadThreshold;
    public final long batchTimeOut;
    public final String context;

    public ScanSession(TCredentials credentials, KeyExtent extent, Set<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, Authorizations authorizations, long readaheadThreshold, long batchTimeOut, String context) {
        super(credentials);
        this.extent = extent;
        this.columnSet = columnSet;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.auths = authorizations;
        this.readaheadThreshold = readaheadThreshold;
        this.batchTimeOut = batchTimeOut;
        this.context = context;
    }

    @Override
    public boolean cleanup() {
        boolean ret;
        try {
            if (this.nextBatchTask != null) {
                this.nextBatchTask.cancel(true);
            }
        }
        finally {
            ret = this.scanner != null ? this.scanner.close() : true;
        }
        return ret;
    }
}

