/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.metrics.Metrics2TabletServerMetrics;
import org.apache.accumulo.tserver.metrics.Metrics2TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.Metrics2TabletServerScanMetrics;
import org.apache.accumulo.tserver.metrics.Metrics2TabletServerUpdateMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerMBeanImpl;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;

public class TabletServerMetricsFactory {
    private final boolean useOldMetrics;
    private final MetricsSystem metricsSystem;

    public TabletServerMetricsFactory(AccumuloConfiguration conf) {
        Objects.requireNonNull(conf);
        this.useOldMetrics = conf.getBoolean(Property.GENERAL_LEGACY_METRICS);
        this.metricsSystem = this.useOldMetrics ? null : MetricsSystemHelper.getInstance();
    }

    public Metrics createMincMetrics() {
        if (this.useOldMetrics) {
            return new TabletServerMinCMetrics();
        }
        return new Metrics2TabletServerMinCMetrics(this.metricsSystem);
    }

    public Metrics createTabletServerMetrics(TabletServer tserver) {
        if (this.useOldMetrics) {
            return new TabletServerMBeanImpl(tserver);
        }
        return new Metrics2TabletServerMetrics(tserver, this.metricsSystem);
    }

    public Metrics createScanMetrics() {
        if (this.useOldMetrics) {
            return new TabletServerScanMetrics();
        }
        return new Metrics2TabletServerScanMetrics(this.metricsSystem);
    }

    public Metrics createUpdateMetrics() {
        if (this.useOldMetrics) {
            return new TabletServerUpdateMetrics();
        }
        return new Metrics2TabletServerUpdateMetrics(this.metricsSystem);
    }
}

