/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.coder.HHXORErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.HHXORErasureEncoder;
import org.apache.hadoop.io.erasurecode.coder.TestHHErasureCoderBase;
import org.junit.Before;
import org.junit.Test;

public class TestHHXORErasureCoder
extends TestHHErasureCoderBase {
    @Before
    public void setup() {
        this.encoderClass = HHXORErasureEncoder.class;
        this.decoderClass = HHXORErasureDecoder.class;
        this.numChunksInBlock = 10;
        this.subPacketSize = 2;
    }

    @Test
    public void testCodingNoDirectBuffer_10x4_erasing_d0() {
        this.prepare(null, 10, 4, new int[]{0}, new int[0]);
        this.testCoding(false);
        this.testCoding(false);
    }

    @Test
    public void testCodingDirectBufferWithConf_10x4_erasing_d0() {
        Configuration conf = new Configuration();
        conf.set("io.erasurecode.codec.rs.rawcoders", "rs_java");
        this.prepare(conf, 10, 4, new int[]{0}, new int[0]);
        this.testCoding(true);
        this.testCoding(true);
    }

    @Test
    public void testCodingDirectBuffer_10x4_erasing_p1() {
        this.prepare(null, 10, 4, new int[0], new int[]{1});
        this.testCoding(true);
        this.testCoding(true);
    }

    @Test
    public void testCodingDirectBuffer_10x4_erasing_d4() {
        this.prepare(null, 10, 4, new int[]{4}, new int[0]);
        this.testCoding(true);
        this.testCoding(true);
    }

    @Test
    public void testCodingDirectBuffer_10x4_erasing_d0_p0() {
        this.prepare(null, 10, 4, new int[]{0}, new int[]{0});
        this.testCoding(true);
        this.testCoding(true);
    }

    @Test
    public void testCodingBothBuffers_10x4_erasing_d0_p0() {
        this.prepare(null, 10, 4, new int[]{0}, new int[]{0});
        this.testCoding(true);
        this.testCoding(false);
        this.testCoding(true);
        this.testCoding(false);
    }

    @Test
    public void testCodingDirectBuffer_10x4_erasure_of_d2_d4_p0() {
        this.prepare(null, 10, 4, new int[]{2, 4}, new int[]{0});
        this.testCoding(true);
    }

    @Test
    public void testCodingDirectBuffer_10x4_erasing_d0_d1_p0_p1() {
        this.prepare(null, 10, 4, new int[]{0, 1}, new int[]{0, 1});
        this.testCoding(true);
    }

    @Test
    public void testCodingDirectBuffer_6x3_erasing_d0_p0() {
        this.prepare(null, 6, 3, new int[]{0}, new int[]{0});
        this.testCoding(true);
    }
}

