/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Random;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

@Deprecated
abstract class ChaCha20Base
implements IndCpaCipher {
    public static final int BLOCK_SIZE_IN_INTS = 16;
    public static final int BLOCK_SIZE_IN_BYTES = 64;
    public static final int KEY_SIZE_IN_INTS = 8;
    public static final int KEY_SIZE_IN_BYTES = 32;
    private static final int[] SIGMA = ChaCha20Base.toIntArray(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107});
    int[] key;
    private final int initialCounter;

    ChaCha20Base(byte[] key, int initialCounter) throws InvalidKeyException {
        if (key.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.key = ChaCha20Base.toIntArray(key);
        this.initialCounter = initialCounter;
    }

    abstract int[] createInitialState(int[] var1, int var2);

    abstract int nonceSizeInBytes();

    @Override
    public byte[] encrypt(byte[] plaintext) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.nonceSizeInBytes()) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer ciphertext = ByteBuffer.allocate(this.nonceSizeInBytes() + plaintext.length);
        this.encrypt(ciphertext, plaintext);
        return ciphertext.array();
    }

    void encrypt(ByteBuffer output, byte[] plaintext) throws GeneralSecurityException {
        if (output.remaining() - this.nonceSizeInBytes() < plaintext.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] nonce = Random.randBytes(this.nonceSizeInBytes());
        output.put(nonce);
        this.process(nonce, output, ByteBuffer.wrap(plaintext));
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws GeneralSecurityException {
        return this.decrypt(ByteBuffer.wrap(ciphertext));
    }

    byte[] decrypt(ByteBuffer ciphertext) throws GeneralSecurityException {
        if (ciphertext.remaining() < this.nonceSizeInBytes()) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] nonce = new byte[this.nonceSizeInBytes()];
        ciphertext.get(nonce);
        ByteBuffer plaintext = ByteBuffer.allocate(ciphertext.remaining());
        this.process(nonce, plaintext, ciphertext);
        return plaintext.array();
    }

    private void process(byte[] nonce, ByteBuffer output, ByteBuffer input) throws GeneralSecurityException {
        int length = input.remaining();
        int numBlocks = length / 64 + 1;
        for (int i = 0; i < numBlocks; ++i) {
            ByteBuffer keyStreamBlock = this.chacha20Block(nonce, i + this.initialCounter);
            if (i == numBlocks - 1) {
                Bytes.xor(output, input, keyStreamBlock, length % 64);
                continue;
            }
            Bytes.xor(output, input, keyStreamBlock, 64);
        }
    }

    ByteBuffer chacha20Block(byte[] nonce, int counter) {
        int[] state = this.createInitialState(ChaCha20Base.toIntArray(nonce), counter);
        int[] workingState = (int[])state.clone();
        ChaCha20Base.shuffleState(workingState);
        for (int i = 0; i < state.length; ++i) {
            int n = i;
            state[n] = state[n] + workingState[i];
        }
        ByteBuffer out = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        out.asIntBuffer().put(state, 0, 16);
        return out;
    }

    static void setSigmaAndKey(int[] state, int[] key) {
        System.arraycopy(SIGMA, 0, state, 0, SIGMA.length);
        System.arraycopy(key, 0, state, SIGMA.length, 8);
    }

    static void shuffleState(int[] state) {
        for (int i = 0; i < 10; ++i) {
            ChaCha20Base.quarterRound(state, 0, 4, 8, 12);
            ChaCha20Base.quarterRound(state, 1, 5, 9, 13);
            ChaCha20Base.quarterRound(state, 2, 6, 10, 14);
            ChaCha20Base.quarterRound(state, 3, 7, 11, 15);
            ChaCha20Base.quarterRound(state, 0, 5, 10, 15);
            ChaCha20Base.quarterRound(state, 1, 6, 11, 12);
            ChaCha20Base.quarterRound(state, 2, 7, 8, 13);
            ChaCha20Base.quarterRound(state, 3, 4, 9, 14);
        }
    }

    static void quarterRound(int[] x, int a, int b, int c, int d) {
        int n = a;
        x[n] = x[n] + x[b];
        x[d] = ChaCha20Base.rotateLeft(x[d] ^ x[a], 16);
        int n2 = c;
        x[n2] = x[n2] + x[d];
        x[b] = ChaCha20Base.rotateLeft(x[b] ^ x[c], 12);
        int n3 = a;
        x[n3] = x[n3] + x[b];
        x[d] = ChaCha20Base.rotateLeft(x[d] ^ x[a], 8);
        int n4 = c;
        x[n4] = x[n4] + x[d];
        x[b] = ChaCha20Base.rotateLeft(x[b] ^ x[c], 7);
    }

    static int[] toIntArray(byte[] input) {
        IntBuffer intBuffer = ByteBuffer.wrap(input).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] ret = new int[intBuffer.remaining()];
        intBuffer.get(ret);
        return ret;
    }

    private static int rotateLeft(int x, int y) {
        return x << y | x >>> -y;
    }
}

